$(document).ready(function() {
    var base_url = $("body").data("base_url");
    
    $("#producto").select2();
    
    $("#tipo_movimiento").change(function() {
        var tipo = $(this).val();
        if(tipo == "salida") {
            $("#cantidad").attr("max", $("#stock_actual").val());
        } else {
            $("#cantidad").removeAttr("max");
        }
    });

    $("#producto").change(function() {
        var producto_id = $(this).val();
        if (producto_id != "") {
            $.ajax({
                url: base_url + "admin/inventario/productos/getProductoById",
                type: "POST",
                data: { id: producto_id },
                dataType: "json",
                success: function(resp) {
                    $("#stock_actual").val(resp.stock_actual);
                    if($("#tipo_movimiento").val() == "salida") {
                        $("#cantidad").attr("max", resp.stock_actual);
                    }
                }
            });
        } else {
            $("#stock_actual").val("");
            $("#cantidad").removeAttr("max");
        }
    });

    $("#form-movimiento").submit(function(e) {
        var tipo = $("#tipo_movimiento").val();
        var cantidad = parseInt($("#cantidad").val());
        var stock = parseInt($("#stock_actual").val());

        if(tipo == "salida" && cantidad > stock) {
            e.preventDefault();
            Swal.fire({
                type: 'error',
                title: 'Error',
                text: 'La cantidad de salida no puede ser mayor al stock actual'
            });
        }
    });
});