$(document).ready(function() {
    var base_url = $("body").data("base_url");
    $("#producto").select2();
    
    $(document).on("click", ".btn-agregar", function() {
        var producto_id = $("#producto").val();
        var producto_texto = $("#producto option:selected").text();
        var cantidad = $("#cantidad").val();
        var precio = $("#precio").val();

        if (producto_id != "" && cantidad != "" && precio != "") {
            var subtotal = cantidad * precio;
            var html = "<tr>";
            html += "<td><input type='hidden' name='productos[]' value='"+producto_id+"'>"+producto_texto+"</td>";
            html += "<td><input type='hidden' name='cantidades[]' value='"+cantidad+"'>"+cantidad+"</td>";
            html += "<td><input type='hidden' name='precios[]' value='"+precio+"'>"+precio+"</td>";
            html += "<td><input type='hidden' name='importes[]' value='"+subtotal+"'>"+subtotal+"</td>";
            html += "<td><button type='button' class='btn btn-danger btn-remove-producto'><i class='fa fa-times'></i></button></td>";
            html += "</tr>";
            $("#tbCompras tbody").append(html);
            calcularTotal();
            $("#producto").val(null).trigger('change');
            $("#cantidad").val("");
            $("#precio").val("");
        } else {
            alert("Complete todos los campos");
        }
    });

    $(document).on("click", ".btn-remove-producto", function() {
        $(this).closest("tr").remove();
        calcularTotal();
    });

    $("#producto").change(function() {
        var producto_id = $(this).val();
        if (producto_id != "") {
            $.ajax({
                url: base_url + "admin/inventario/productos/getProductoById",
                type: "POST",
                data: { id: producto_id },
                dataType: "json",
                success: function(resp) {
                    $("#precio").val(resp.precio_compra);
                }
            });
        } else {
            $("#precio").val("");
        }
    });

    function calcularTotal() {
        var total = 0;
        $("#tbCompras tbody tr").each(function() {
            total += parseFloat($(this).find("td:eq(3)").text());
        });
        $("#total").val(total.toFixed(2));
    }
});