

<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            Sedes
            <small>Listado</small>
        </h1>
        <?php if ($this->session->flashdata('success')): ?>
    <div class="alert alert-success" id="successMessage">
        <i class="fa fa-check-circle"></i> <?= $this->session->flashdata('success'); ?>
    </div>
<?php endif; ?>

    </section>
    <!-- Main content -->
    <section class="content">
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title">Lista de Sedes</h3>
                <div class="box-tools pull-right">
                    <a href="<?= base_url('mantenimiento/sedes/create') ?>" class="btn btn-primary btn-flat"><span class="fa fa-plus"></span> Agregar Sede</a>
                </div>
            </div>
            <div class="box-body">
                <div class="table-responsive">
                    <table id="example1" class="table table-bordered table-hover">
                        <thead style="background-color: rgb(60, 141, 188); color: white; text-align: center; width: 145.062px;">
                            <tr>
                                <!-- <th>#</th> -->
                                <th>Nombre</th>
                                <th>Estado</th>
                                <th>Opciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(!empty($sedes)): ?>
                                <?php foreach($sedes as $sede): ?>
                                    <tr>
                                        <!-- <td><?= $sede->cod_sede; ?></td> -->
                                        <td><?= $sede->nombre_sede; ?></td>
                                        <td>
                                            <?php if($sede->estado_sede == 1): ?>
                                                <span class="label label-success">Activo</span>
                                            <?php else: ?>
                                                <span class="label label-danger">Inactivo</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="<?= base_url('mantenimiento/sedes/edit/'.$sede->cod_sede) ?>" class="btn btn-warning btn-flat"><i class="fa fa-pencil"></i></a>
                                                <a href="<?= base_url('mantenimiento/sedes/delete/'.$sede->cod_sede) ?>" class="btn btn-danger btn-flat" onclick="return confirm('¿Está seguro de eliminar este registro?');"><i class="fa fa-trash"></i></a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
 $(document).ready(function() {
    // Mostrar mensaje de éxito por 3 segundos
    setTimeout(function() {
        $('#successMessage').fadeOut('slow');  // Desaparecer el mensaje después de 3 segundos
    }, 2000);

    // DataTable configuration
    $('#example1').DataTable({
        "language": {
            "lengthMenu": "Mostrar _MENU_ registros por página",
            "zeroRecords": "No se encontraron resultados",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "No hay registros disponibles",
            "infoFiltered": "(filtrado de _MAX_ registros totales)",
            "search": "Buscar:",
            "paginate": {
                "first": "Primero",
                "last": "Último",
                "next": "Siguiente",
                "previous": "Anterior"
            }
        }
    });
});
</script>