<div class="content-wrapper">
    <section class="content-header">
        <h1>Lista de Consentimientos Médicos</h1>
        <small>Documentos disponibles para consulta</small>
    </section>
    
    <section class="content">
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title">Documentos PDF Disponibles</h3>
            </div>
            <div class="box-body">
                <?php if (empty($pdfs)): ?>
                    <div class="alert alert-info">
                        <i class="fa fa-info-circle"></i>
                        No se encontraron documentos PDF disponibles.
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>Documento</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($pdfs as $pdf): ?>
                                    <tr>
                                        <td>
                                            <i class="fa fa-file-pdf-o text-red"></i>
                                            <?php echo htmlspecialchars($pdf); ?>
                                        </td>
                                        <td>
                                            <a href="<?php echo base_url('doctorpdf/ver/' . urlencode($pdf)); ?>" 
                                               target="_blank" 
                                               class="btn btn-primary btn-sm"
                                               title="Ver documento">
                                                <i class="fa fa-eye"></i> Ver
                                            </a>
                                            <a href="<?php echo base_url('doctorpdf/descargar/' . urlencode($pdf)); ?>" 
                                               class="btn btn-success btn-sm"
                                               title="Descargar documento">
                                                <i class="fa fa-download"></i> Descargar
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
</div>

<style>
.table th {
    background-color: #f4f4f4;
}
.btn-sm {
    margin-right: 5px;
}
.text-red {
    color: #d73925;
}
</style></style>