<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Sistema Dental - Inicio de Sesión</title>
    <link rel="icon" type="image/png" href="<?= base_url('assets/img/icon.png') ?>">

    <!-- Fuentes -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/template/bootstrap/css/bootstrap.min.css">

    <style>
        :root {
            --primary-color: #04C8C8;
            --secondary-color: #B2E0F9;
            --accent-color: #5DA9E9;
            --text-color: #333333;
            --light-color: #FFFFFF;
            --shadow-color: rgba(0, 0, 0, 0.05);
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(to bottom, #04C8C8, #ffffff);
            color: var(--text-color);
        }


        .login-container {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            padding: 20px;
        }

        .login-card {
            background-color: var(--light-color);
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
            width: 100%;
            max-width: 420px;
            position: relative;
        }

        .login-header {
            background-color: var(--primary-color);
            padding: 30px 25px;
            text-align: center;
        }

        .login-header h2 {
            margin: 0;
            color: var(--text-color);
            font-weight: 600;
            font-size: 24px;
        }

        .login-header p {
            margin-top: 5px;
            color: var(--text-color);
            opacity: 0.8;
            font-size: 14px;
        }

        .login-body {
            padding: 30px 25px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-control {
            height: 48px;
            border-radius: 8px;
            border: 1px solid #e1e5eb;
            padding: 10px 15px;
            font-size: 14px;
            transition: all 0.3s ease;
        }

        .form-control:focus {
            border-color: var(--accent-color);
            box-shadow: 0 0 0 0.2rem rgba(93, 169, 233, 0.25);
        }

        .input-group-text {
            background-color: transparent;
            border-right: none;
            color: #adb5bd;
        }

        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            height: 48px;
            border-radius: 8px;
            font-weight: 500;
            letter-spacing: 0.3px;
            box-shadow: 0 4px 12px rgba(93, 169, 233, 0.2);
            transition: all 0.3s ease;
            width: 100%;
        }

        .btn-primary:hover,
        .btn-primary:focus {
            background-color: #4D94D1;
            border-color: #4D94D1;
            box-shadow: 0 6px 15px rgba(93, 169, 233, 0.3);
        }

        .login-footer {
            padding: 15px 25px 25px;
            text-align: center;
        }

        .login-footer a {
            color: var(--accent-color);
            text-decoration: none;
            font-weight: 500;
            font-size: 14px;
            transition: all 0.3s ease;
        }

        .login-footer a:hover {
            color: #4D94D1;
            text-decoration: underline;
        }

        .social-login {
            display: flex;
            justify-content: center;
            margin-top: 25px;
            gap: 15px;
        }

        .social-btn {
            width: 42px;
            height: 42px;
            border-radius: 50%;
            background-color: #f8f9fa;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--text-color);
            transition: all 0.3s ease;
            box-shadow: 0 4px 8px var(--shadow-color);
        }

        .social-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 12px var(--shadow-color);
        }

        .social-btn.facebook {
            color: #3b5998;
        }

        .social-btn.twitter {
            color: #1da1f2;
        }

        .social-btn.google {
            color: #ea4335;
        }

        .alert {
            border-radius: 8px;
            font-size: 14px;
        }

        .dental-icon {
            width: 100px;
            filter: brightness(0) saturate(100%) invert(0);
        }

        /* Logo placeholder - reemplazar con logo real */
        .dental-logo {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 15px;
        }

        /* @media (max-width: 576px) {
            .login-card {
                border-radius: 0;
            }
        } */

        .input-group .form-control {
            width: 90%;
            margin-left: 30px;
        }

        .input-group {
            display: flex !important;
            align-items: center;
        }
    </style>
</head>

<body>
    <div class="login-container">
        <div class="login-card">
            <div class="login-header">
                <div class="dental-logo">
                    <img src="<?= base_url('assets/img/icon.png') ?>" alt="Icono dental" class="dental-icon">

                </div>
                <h2>SISTEMA DENTAL</h2>
                <p>Ingrese sus credenciales para acceder</p>
            </div>

            <div class="login-body">
                <?php if ($this->session->flashdata("error")): ?>
                    <div class="alert alert-danger" role="alert">
                        <i class="fas fa-exclamation-circle mr-2"></i> <?php echo $this->session->flashdata("error") ?>
                    </div>
                <?php endif; ?>

                <form action="<?php echo base_url(); ?>auth/login" method="post">
                    <div class="form-group">
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><i class="fas fa-user"></i></span>
                            </div>
                            <input type="text" name="username" class="form-control" placeholder="Nombre de usuario" required>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><i class="fas fa-lock"></i></span>
                            </div>
                            <input type="password" id="password" name="paswoord" class="form-control" placeholder="Contraseña" required>
                            <span class="input-group-text" id="togglePassword" style="cursor: pointer; position: absolute; right: 15px; top: 50%; transform: translateY(-50%); z-index: 9999;">
                                <i class="fas fa-eye-slash"></i> <!-- Icono por defecto (ocultar) -->
                            </span>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-sign-in-alt mr-2"></i> Iniciar Sesión
                    </button>
                </form>
            </div>

            <div class="login-footer">
                <!-- <a href="<?php echo base_url(); ?>regpersona">¿No tiene cuenta? Crear una ahora</a> -->

                <!-- <div class="social-login">
                    <a href="#" class="social-btn facebook">
                        <i class="fab fa-facebook-f"></i>
                    </a>
                    <a href="#" class="social-btn twitter">
                        <i class="fab fa-twitter"></i>
                    </a>
                    <a href="#" class="social-btn google">
                        <i class="fab fa-google"></i>
                    </a>
                </div> -->
            </div>
        </div>
    </div>

    <!-- JavaScript -->
    <script src="<?php echo base_url(); ?>assets/template/bootstrap/js/jquery-1.11.1.min.js"></script>
    <script src="<?php echo base_url(); ?>assets/template/bootstrap/js/bootstrap.min.js"></script>
    <script>
        const togglePassword = document.getElementById('togglePassword');
        const passwordField = document.getElementById('password');

        togglePassword.addEventListener('click', function(e) {
            // Cambiar el tipo de input de contraseña a texto o viceversa
            const type = passwordField.type === 'password' ? 'text' : 'password';
            passwordField.type = type;

            // Cambiar el icono según el tipo del campo
            this.innerHTML = type === 'password' ? '<i class="fas fa-eye-slash"></i>' : '<i class="fas fa-eye"></i>';
        });
    </script>
</body>

</html>