<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?>

<div class="content-wrapper">
    <!-- <pre><?php print_r($productos); ?></pre> -->
    <section class="content-header">
        <h1>
            Reportes de Inventario
            <small>Reporte de Stock</small>
        </h1>
    </section>
    <section class="content">
        <div class="box box-solid">
            <div class="box-header with-border">
                <h3 class="box-title">Listado de Productos</h3>
                <div class="box-tools">
                    <button type="button" class="btn btn-success btn-flat" onclick="window.print()">
                        <i class="fa fa-print"></i> Imprimir
                    </button>
                </div>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-md-12">
                        <?php if(empty($productos)): ?>
                            <div class="alert alert-warning">
                                <p>No hay productos que coincidan con los filtros seleccionados.</p>
                            </div>
                        <?php else: ?>
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Código</th>
                                        <th>Nombre</th>
                                        <th>Categoría</th>
                                        <th>Stock</th>
                                        <th>Precio Compra</th>
                                        <th>Precio Venta</th>
                                        <th>Estado</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($productos as $producto): ?>
                                        <tr>
                                            <td><?php echo $producto->id_producto; ?></td>
                                            <td><?php echo $producto->codigo; ?></td>
                                            <td><?php echo $producto->nombre; ?></td>
                                            <td><?php echo $producto->categoria; ?></td>
                                            <td><?php echo $producto->stock_actual; ?></td>
                                            <td><?php echo number_format($producto->precio_compra, 2); ?></td>
                                            <td><?php echo number_format($producto->precio_venta, 2); ?></td>
                                            <td>
                                                <?php if($producto->estado == "1"): ?>
                                                    <span class="label label-success">Activo</span>
                                                <?php else: ?>
                                                    <span class="label label-danger">Inactivo</span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
$(document).ready(function() {
    $('#example1').DataTable({
        "order": [[0, "desc"]], // Ordenar por ID (primera columna) de forma descendente
        "language": {
            "lengthMenu": "Mostrar _MENU_ registros por página",
            "zeroRecords": "No se encontraron resultados",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "No hay registros disponibles",
            "infoFiltered": "(filtrado de _MAX_ registros totales)",
            "search": "Buscar:",
            "paginate": {
                "first": "Primero",
                "last": "Último",
                "next": "Siguiente",
                "previous": "Anterior"
            }
        }
    });
});
</script>