<div class="content-wrapper">
    <section class="content-header">
        <h1>
            Proveedores
            <small>Listado</small>
        </h1>
    </section>
    <section class="content">
        <div class="box">
            <div class="box-header">
                <h3 class="box-title">Lista de Proveedores</h3>
                <div class="box-tools">
                    <a href="<?php echo base_url('admin/inventario/proveedores/add');?>" class="btn btn-primary btn-flat"><i class="fa fa-plus"></i> Agregar Proveedor</a>
                </div>
            </div>
            <div class="box-body">
                <table id="example1" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>RUC</th>
                            <th>Razón Social</th>
                            <th>Teléfono</th>
                            <th>Email</th>
                            <th>Dirección</th>
                            <th>Opciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(!empty($proveedores)):?>
                            <?php foreach($proveedores as $proveedor):?>
                                <tr>
                                    <td><?php echo $proveedor->id_proveedor;?></td>
                                    <td><?php echo $proveedor->ruc;?></td>
                                    <td><?php echo $proveedor->razon_social;?></td>
                                    <td><?php echo $proveedor->telefono;?></td>
                                    <td><?php echo $proveedor->email;?></td>
                                    <td><?php echo $proveedor->direccion;?></td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="<?php echo base_url('admin/inventario/proveedores/edit/'.$proveedor->id_proveedor);?>" class="btn btn-warning btn-flat"><i class="fa fa-pencil"></i></a>
                                            <a href="<?php echo base_url('admin/inventario/proveedores/delete/'.$proveedor->id_proveedor);?>" class="btn btn-danger btn-flat"><i class="fa fa-trash"></i></a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach;?>
                        <?php endif;?>
                    </tbody>
                </table>
            </div>
        </div>
    </section>
</div>

<script>
$(document).ready(function() {
    $("#example1").DataTable({
        "order": [[0, "desc"]], // Ordenar por ID (primera columna) de forma descendente
        "language": {
            "lengthMenu": "Mostrar _MENU_ registros por página",
            "zeroRecords": "No se encontraron resultados",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "No hay registros disponibles",
            "infoFiltered": "(filtrado de _MAX_ registros totales)",
            "search": "Buscar:",
            "paginate": {
                "first": "Primero",
                "last": "Último",
                "next": "Siguiente",
                "previous": "Anterior"
            }
        }
    });
});
</script>