<div class="content-wrapper">
    <section class="content-header">
        <h1>
            Proveedores
            <small>Nuevo</small>
        </h1>
    </section>
    <section class="content">
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title">Agregar Proveedor</h3>
            </div>
            <div class="box-body">
                <?php if($this->session->flashdata("error")):?>
                    <div class="alert alert-danger alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                        <p><i class="icon fa fa-ban"></i><?php echo $this->session->flashdata("error"); ?></p>
                    </div>
                <?php endif;?>
                <form action="<?php echo base_url('admin/inventario/proveedores/store');?>" method="POST">
                    <div class="form-group">
                        <label for="ruc">RUC:</label>
                        <input type="text" class="form-control" id="ruc" name="ruc" required>
                    </div>
                    <div class="form-group">
                        <label for="razon_social">Razón Social:</label>
                        <input type="text" class="form-control" id="razon_social" name="razon_social" required readonly>
                    </div>
                    <div class="form-group">
                        <label for="nombre_comercial">Nombre Comercial:</label>
                        <input type="text" class="form-control" id="nombre_comercial" name="nombre_comercial" readonly>
                    </div>
                    <div class="form-group">
                        <label for="direccion">Dirección:</label>
                        <input type="text" class="form-control" id="direccion" name="direccion" readonly>
                    </div>
                    <div class="form-group">
                        <label for="telefono">Teléfono:</label>
                        <input type="text" class="form-control" id="telefono" name="telefono">
                    </div>
                    <div class="form-group">
                        <label for="email">Email:</label>
                        <input type="email" class="form-control" id="email" name="email">
                    </div>
                    <div class="form-group">
                        <label for="contacto">Persona de Contacto:</label>
                        <input type="text" class="form-control" id="contacto" name="contacto">
                    </div>
                    <div class="form-group">
                        <label for="telefono_contacto">Teléfono de Contacto:</label>
                        <input type="text" class="form-control" id="telefono_contacto" name="telefono_contacto">
                    </div>
                    <div class="form-group">
                        <button type="submit" class="btn btn-success btn-flat">Guardar</button>
                        <a href="<?php echo base_url('admin/inventario/proveedores');?>" class="btn btn-danger btn-flat">Volver</a>
                    </div>
                </form>
            </div>
        </div>
    </section>
</div>



<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
        var rucChecked = false; 

        $('#ruc').on('blur', function() {
            var ruc = $(this).val(); // Obtener el RUC ingresado

            if (ruc && !rucChecked) { 
                rucChecked = true; 

                $.ajax({
                    url: 'https://my.apidev.pro/api/ruc/' + ruc + '?api_token=bdfa8657e3b70aaacabe568201917549aa8ada6bdd6cf3e1707c4e7e26dae946',
                    method: 'GET',
                    success: function(response) {
                        // Limpiar posibles errores previos
                        $('#ruc-error').hide();

                        // Comprobar si hay datos dentro de 'data' en la respuesta
                        if (response.success && response.data) {

                            // Poblar los campos con los datos de SUNAT
                            $('#razon_social').val(response.data.nombre_o_razon_social).prop('readonly', true);
                            $('#nombre_comercial').val(response.data.nombre_o_razon_social).prop('readonly', true); 
                            $('#direccion').val(response.data.direccion).prop('readonly', true);

                            // Si no hay teléfono o email, dejamos esos campos habilitados
                            $('#telefono').prop('disabled', false);
                            $('#email').prop('disabled', false);
                            $('#contacto').prop('disabled', false);
                            $('#telefono_contacto').prop('disabled', false);
                        } else {
                            
                            $('#ruc-error').show();
                        }
                    },
                    error: function() {
                        
                        $('#ruc-error').show();
                    }
                });
            }
        });
    });
</script>


