<div class="content-wrapper">
    <section class="content-header">
        <h1>
            Productos
            <small>Listado</small>
        </h1>
    </section>
    
    <!-- Sección de estadísticas y alertas -->
    <section class="content" style="padding-bottom: 0; min-height: 1px !important;">
        <div class="row">
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-aqua" style="overflow: hidden; height: 100px;">
                    <div class="inner">
                        <h3><?php echo isset($estadisticas['total_productos']) ? $estadisticas['total_productos'] : count($productos); ?></h3>
                        <p>Total Productos</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-cubes"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow" style="overflow: hidden; height: 100px;">
                    <div class="inner">
                        <h3><?php 
                            $bajos = 0;
                            if(!empty($productos)) {
                                foreach($productos as $p) {
                                    if($p->stock_actual <= $p->stock_minimo) {
                                        $bajos++;
                                    }
                                }
                            }
                            echo $bajos;
                        ?></h3>
                        <p>Productos Bajos en Stock</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-warning"></i>
                    </div>
                    <a href="<?php echo base_url('admin/productos/bajos_stock'); ?>" class="small-box-footer">Ver detalles <i class="fa fa-arrow-circle-right"></i></a>
                </div>
            </div>
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green" style="overflow: hidden; height: 100px;">
                    <div class="inner">
                        <h3><?php 
                            $activos = 0;
                            if(!empty($productos)) {
                                foreach($productos as $p) {
                                    if($p->estado == 1) {
                                        $activos++;
                                    }
                                }
                            }
                            echo $activos;
                        ?></h3>
                        <p>Productos Activos</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-check-circle"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red" style="overflow: hidden; height: 100px;">
                    <div class="inner">
                        <h3><?php 
                            $inactivos = 0;
                            if(!empty($productos)) {
                                foreach($productos as $p) {
                                    if($p->estado == 0) {
                                        $inactivos++;
                                    }
                                }
                            }
                            echo $inactivos;
                        ?></h3>
                        <p>Productos Inactivos</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-ban"></i>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <section class="content">
        <div class="box">
            <div class="box-header">
                <h3 class="box-title">Lista de Productos</h3>
                <div class="box-tools">
                    <a href="<?php echo base_url('admin/inventario/productos/add');?>" class="btn btn-primary btn-flat"><i class="fa fa-plus"></i> Agregar Producto</a>
                </div>
            </div>
            
            <!-- Filtros de búsqueda -->
            <div class="box-body">
                <div class="row">
                    <div class="col-md-12">
                        <form id="form-filtros" class="form-inline">
                            <div class="form-group">
                                <label for="categoria">Categoría:</label>
                                <select class="form-control select2" id="categoria" name="categoria">
                                    <option value="">Todas</option>
                                    <?php if(isset($categorias)): ?>
                                        <?php foreach($categorias as $categoria): ?>
                                            <option value="<?php echo $categoria->id_categoria; ?>"><?php echo $categoria->nombre; ?></option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="estado">Estado:</label>
                                <select class="form-control" id="estado" name="estado">
                                    <option value="">Todos</option>
                                    <option value="1">Activo</option>
                                    <option value="0">Inactivo</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="stock">Stock:</label>
                                <select class="form-control" id="stock" name="stock">
                                    <option value="">Todos</option>
                                    <option value="bajo">Bajo stock</option>
                                    <option value="normal">Stock normal</option>
                                </select>
                            </div>
                            <button type="button" id="btn-filtrar" class="btn btn-default"><i class="fa fa-search"></i> Filtrar</button>
                            <button type="button" id="btn-reset" class="btn btn-warning"><i class="fa fa-refresh"></i> Limpiar</button>
                        </form>
                    </div>
                </div>
                <hr>
                <!-- Búsqueda rápida -->
                <div class="row">
                    <div class="col-md-6">
                        <div class="input-group">
                            <input type="text" class="form-control" id="busqueda_rapida" placeholder="Buscar por nombre o código de producto...">
                            <span class="input-group-btn">
                                <button type="button" id="btn-buscar" class="btn btn-info btn-flat"><i class="fa fa-search"></i></button>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="box-body" style="padding:0px 10px !important">
                <table id="example1" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Código</th>
                            <th>Nombre</th>
                            <th>Categoría</th>
                            <th>Stock</th>
                            <th>Precio Compra</th>
                            <th>Precio Venta</th>
                            <th>Estado</th>
                            <th>Opciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(!empty($productos)):?>
                            <?php foreach($productos as $producto):?>
                                <tr>
                                    <td><?php echo $producto->id_producto;?></td>
                                    <td><?php echo $producto->codigo;?></td>
                                    <td><?php echo $producto->nombre;?></td>
                                    <td><?php echo $producto->categoria;?></td>
                                    <td>
                                        <?php if($producto->stock_actual <= $producto->stock_minimo): ?>
                                            <span class="label label-danger"><?php echo $producto->stock_actual;?></span>
                                        <?php elseif($producto->stock_actual <= ($producto->stock_minimo * 1.5)): ?>
                                            <span class="label label-warning"><?php echo $producto->stock_actual;?></span>
                                        <?php else: ?>
                                            <span class="label label-success"><?php echo $producto->stock_actual;?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo $producto->precio_compra;?></td>
                                    <td><?php echo $producto->precio_venta;?></td>
                                    <td>
                                        <?php if($producto->estado == 1): ?>
                                            <span class="label label-success">Activo</span>
                                        <?php else: ?>
                                            <span class="label label-danger">Inactivo</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="<?php echo base_url('admin/inventario/productos/edit/'.$producto->id_producto);?>" class="btn btn-warning btn-flat" title="Editar"><i class="fa fa-pencil"></i></a>
                                            <button type="button" class="btn btn-info btn-flat btn-registrar-salida" data-id="<?php echo $producto->id_producto;?>" data-nombre="<?php echo $producto->nombre;?>" data-stock="<?php echo $producto->stock_actual;?>" title="Registrar Salida" data-toggle="modal" data-target="#modal-salida"><i class="fa fa-sign-out"></i></button>
                                            <a href="<?php echo base_url('admin/inventario/historial/'.$producto->id_producto);?>" class="btn btn-primary btn-flat" title="Ver Historial"><i class="fa fa-history"></i></a>
                                            <?php if($producto->estado == 1): ?>
                                                <a href="<?php echo base_url('admin/productos/desactivar/'.$producto->id_producto);?>" class="btn btn-danger btn-flat" title="Desactivar"><i class="fa fa-ban"></i></a>
                                            <?php else: ?>
                                                <a href="<?php echo base_url('admin/productos/activar/'.$producto->id_producto);?>" class="btn btn-success btn-flat" title="Activar"><i class="fa fa-check"></i></a>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach;?>
                        <?php endif;?>
                    </tbody>
                </table>
            </div>
        </div>
    </section>
</div>

<!-- Modal para registrar salida de producto -->
<div class="modal fade" id="modal-salida">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Registrar Salida de Producto</h4>
            </div>
            <form action="<?php echo base_url('admin/inventario/store_salida');?>" method="POST">
                <div class="modal-body">
                    <input type="hidden" name="id_producto" id="id_producto">
                    <div class="form-group">
                        <label for="nombre_producto">Producto:</label>
                        <input type="text" class="form-control" id="nombre_producto" readonly>
                    </div>
                    <div class="form-group">
                        <label for="stock_actual">Stock Actual:</label>
                        <input type="text" class="form-control" id="stock_actual" readonly>
                    </div>
                    <div class="form-group">
                        <label for="cantidad">Cantidad a Retirar:</label>
                        <input type="number" class="form-control" id="cantidad" name="cantidad" min="1" required>
                    </div>
                    <div class="form-group">
                        <label for="observaciones">Observaciones:</label>
                        <textarea class="form-control" id="observaciones" name="observaciones" rows="3" placeholder="Motivo de la salida"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Registrar Salida</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Inicializar Select2
    if ($.fn.select2) {
        $('.select2').select2();
    }
    
    // Inicializar DataTable solo si no está ya inicializado
    if (!$.fn.DataTable.isDataTable("#example1")) {
        var table = $("#example1").DataTable({
            "order": [[0, "desc"]], // Ordenar por ID (primera columna) de forma descendente
            "language": {
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "zeroRecords": "No se encontraron resultados",
                "info": "Mostrando página _PAGE_ de _PAGES_",
                "infoEmpty": "No hay registros disponibles",
                "infoFiltered": "(filtrado de _MAX_ registros totales)",
                "search": "Buscar:",
                "paginate": {
                    "first": "Primero",
                    "last": "Último",
                    "next": "Siguiente",
                    "previous": "Anterior"
                }
            }
        });
        
        // Búsqueda rápida
        $('#busqueda_rapida').on('keyup', function() {
            table.search(this.value).draw();
        });
        
        // Filtrar por categoría, estado y stock
        $('#btn-filtrar').on('click', function() {
            var categoria = $('#categoria').val();
            var estado = $('#estado').val();
            var stock = $('#stock').val();
            
            // Realizar la petición AJAX para filtrar
            $.ajax({
                url: '<?php echo base_url('ProductosFilter/filtrar'); ?>',
                type: 'POST',
                dataType: 'json',
                data: {
                    categoria: categoria,
                    estado: estado,
                    stock: stock
                },
                success: function(response) {
                    // Limpiar la tabla
                    table.clear();
                    
                    // Agregar los nuevos datos
                    if (response.productos && response.productos.length > 0) {
                        $.each(response.productos, function(index, producto) {
                            // Crear las opciones según el estado del producto
                            var opciones = '<div class="btn-group">';
                            opciones += '<a href="<?php echo base_url('admin/inventario/productos/edit/'); ?>' + producto.id_producto + '" class="btn btn-warning btn-flat" title="Editar"><i class="fa fa-pencil"></i></a>';
                            opciones += '<button type="button" class="btn btn-info btn-flat btn-registrar-salida" data-id="' + producto.id_producto + '" data-nombre="' + producto.nombre + '" data-stock="' + producto.stock_actual + '" title="Registrar Salida" data-toggle="modal" data-target="#modal-salida"><i class="fa fa-sign-out"></i></button>';
                            opciones += '<a href="<?php echo base_url('admin/productos/historial/'); ?>' + producto.id_producto + '" class="btn btn-primary btn-flat" title="Ver Historial"><i class="fa fa-history"></i></a>';
                            
                            if (producto.estado == 1) {
                                opciones += '<a href="<?php echo base_url('admin/productos/desactivar/'); ?>' + producto.id_producto + '" class="btn btn-danger btn-flat" title="Desactivar"><i class="fa fa-ban"></i></a>';
                            } else {
                                opciones += '<a href="<?php echo base_url('admin/productos/activar/'); ?>' + producto.id_producto + '" class="btn btn-success btn-flat" title="Activar"><i class="fa fa-check"></i></a>';
                            }
                            
                            opciones += '</div>';
                            
                            // Determinar la clase para el stock
                            var stockClass = '';
                            var stockLabel = '';
                            
                            if (producto.stock_actual <= producto.stock_minimo) {
                                stockClass = 'label-danger';
                            } else if (producto.stock_actual <= (producto.stock_minimo * 1.5)) {
                                stockClass = 'label-warning';
                            } else {
                                stockClass = 'label-success';
                            }
                            
                            stockLabel = '<span class="label ' + stockClass + '">' + producto.stock_actual + '</span>';
                            
                            // Determinar el estado
                            var estadoLabel = '';
                            if (producto.estado == 1) {
                                estadoLabel = '<span class="label label-success">Activo</span>';
                            } else {
                                estadoLabel = '<span class="label label-danger">Inactivo</span>';
                            }
                            
                            // Agregar fila a la tabla
                            table.row.add([
                                producto.id_producto,
                                producto.codigo,
                                producto.nombre,
                                producto.categoria,
                                stockLabel,
                                producto.precio_compra,
                                producto.precio_venta,
                                estadoLabel,
                                opciones
                            ]).draw();
                        });
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Error al filtrar productos:", error);
                    alert("Error al filtrar productos. Por favor, inténtelo de nuevo.");
                }
            });
        });
        
        // Limpiar filtros
        $('#btn-reset').on('click', function() {
            $('#categoria').val('').trigger('change');
            $('#estado').val('');
            $('#stock').val('');
            $('#busqueda_rapida').val('');
            table.search('').columns().search('').draw();
        });
    }
    
    // Usar delegación de eventos para manejar clics en botones de registrar salida
    $(document).on('click', '.btn-registrar-salida', function() {
        var id = $(this).data('id');
        var nombre = $(this).data('nombre');
        var stock = $(this).data('stock');
        
        $('#id_producto').val(id);
        $('#nombre_producto').val(nombre);
        $('#stock_actual').val(stock);
        $('#cantidad').attr('max', stock);
        $('#cantidad').val(1); // Reiniciar el valor a 1 para evitar valores anteriores
    });
    
    // Validar que la cantidad no exceda el stock
    $('#cantidad').on('change', function() {
        var stock = parseInt($('#stock_actual').val());
        var cantidad = parseInt($(this).val());
        
        if (cantidad > stock) {
            alert('La cantidad no puede ser mayor al stock actual');
            $(this).val(stock);
        } else if (cantidad <= 0) {
            alert('La cantidad debe ser mayor a cero');
            $(this).val(1);
        }
    });
});
</script>