<div class="content-wrapper">
    <section class="content-header">
        <h1>
            Historial de Producto
            <small><?php echo $producto->nombre; ?></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url('admin/dashboard'); ?>"><i class="fa fa-dashboard"></i> Inicio</a></li>
            <li><a href="<?php echo base_url('admin/inventario/productos'); ?>">Productos</a></li>
            <li class="active">Historial</li>
        </ol>
    </section>
    
    <section class="content">
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title">Información del Producto</h3>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-bordered">
                            <tr>
                                <th style="width: 150px;">Código:</th>
                                <td><?php echo $producto->codigo; ?></td>
                            </tr>
                            <tr>
                                <th>Nombre:</th>
                                <td><?php echo $producto->nombre; ?></td>
                            </tr>
                            <tr>
                                <th>Categoría:</th>
                                <td><?php echo $producto->categoria; ?></td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-bordered">
                            <tr>
                                <th style="width: 150px;">Stock Actual:</th>
                                <td>
                                    <?php if($producto->stock_actual <= $producto->stock_minimo): ?>
                                        <span class="label label-danger"><?php echo $producto->stock_actual; ?></span>
                                    <?php elseif($producto->stock_actual <= ($producto->stock_minimo * 1.5)): ?>
                                        <span class="label label-warning"><?php echo $producto->stock_actual; ?></span>
                                    <?php else: ?>
                                        <span class="label label-success"><?php echo $producto->stock_actual; ?></span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <th>Stock Mínimo:</th>
                                <td><?php echo $producto->stock_minimo; ?></td>
                            </tr>
                            <tr>
                                <th>Estado:</th>
                                <td>
                                    <?php if($producto->estado == 1): ?>
                                        <span class="label label-success">Activo</span>
                                    <?php else: ?>
                                        <span class="label label-danger">Inactivo</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title">Historial de Movimientos</h3>
            </div>
            <div class="box-body">
                <table id="tabla-movimientos" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>Fecha</th>
                            <th>Tipo</th>
                            <th>Cantidad</th>
                            <th>Usuario</th>
                            <th>Observaciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(!empty($movimientos)): ?>
                            <?php foreach($movimientos as $movimiento): ?>
                                <tr>
                                    <td><?php echo date('d/m/Y H:i', strtotime($movimiento->fecha_movimiento)); ?></td>
                                    <td>
                                        <?php if($movimiento->tipo_movimiento == 'entrada'): ?>
                                            <span class="label label-success">Entrada</span>
                                        <?php elseif($movimiento->tipo_movimiento == 'salida'): ?>
                                            <span class="label label-danger">Salida</span>
                                        <?php else: ?>
                                            <span class="label label-warning">Ajuste</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo $movimiento->cantidad; ?></td>
                                    <td><?php echo $movimiento->usuario; ?></td>
                                    <td><?php echo $movimiento->observaciones; ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="5" class="text-center">No hay movimientos registrados para este producto</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="box-footer">
                <a href="<?php echo base_url('admin/inventario/productos'); ?>" class="btn btn-default">Volver</a>
            </div>
        </div>
    </section>
</div>

<script>
$(document).ready(function() {
    $('#tabla-movimientos').DataTable({
        "order": [[0, "desc"]], // Ordenar por fecha (primera columna) de forma descendente
        "language": {
            "lengthMenu": "Mostrar _MENU_ registros por página",
            "zeroRecords": "No se encontraron resultados",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "No hay registros disponibles",
            "infoFiltered": "(filtrado de _MAX_ registros totales)",
            "search": "Buscar:",
            "paginate": {
                "first": "Primero",
                "last": "Último",
                "next": "Siguiente",
                "previous": "Anterior"
            }
        }
    });
});
</script>