<div class="content-wrapper">
    <section class="content-header">
        <h1>
            Productos
            <small>Nuevo</small>
        </h1>
    </section>
    <section class="content">
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title">Agregar Producto</h3>
            </div>
            <div class="box-body">
                <?php if($this->session->flashdata("error")):?>
                    <div class="alert alert-danger alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                        <p><i class="icon fa fa-ban"></i><?php echo $this->session->flashdata("error"); ?></p>
                    </div>
                <?php endif;?>
                <form action="<?php echo base_url('inventario/store_producto');?>" method="POST">
                    <div class="form-group">
                        <label for="codigo">Código:</label>
                        <input type="text" class="form-control" id="codigo" name="codigo" value="<?php echo $codigo_generado; ?>" readonly>
                        <small class="text-muted">El código se genera automáticamente</small>
                    </div>
                    <div class="form-group">
                        <label for="nombre">Nombre:</label>
                        <input type="text" class="form-control" id="nombre" name="nombre" required>
                    </div>
                    <div class="form-group">
                        <label for="descripcion">Descripción:</label>
                        <textarea class="form-control" id="descripcion" name="descripcion" rows="3"></textarea>
                    </div>
                    <div class="form-group">
                        <label for="precio_compra">Precio Compra:</label>
                        <input type="number" class="form-control" id="precio_compra" name="precio_compra" step="0.01" required>
                    </div>
                    <div class="form-group">
                        <label for="precio_venta">Precio Venta:</label>
                        <input type="number" class="form-control" id="precio_venta" name="precio_venta" step="0.01" required>
                    </div>
                    <div class="form-group">
                        <label for="stock_inicial">Stock Inicial:</label>
                        <input type="number" class="form-control" id="stock_inicial" name="stock_inicial" min="0" value="0" required>
                        <small class="text-muted">Se creará automáticamente un movimiento de "Ajuste Inicial" con esta cantidad</small>
                    </div>
                    <div class="form-group">
                        <label for="stock_minimo">Stock Mínimo:</label>
                        <input type="number" class="form-control" id="stock_minimo" name="stock_minimo" required>
                    </div>
                    <div class="form-group">
                        <label for="categoria">Categoría:</label>
                        <select name="categoria" id="categoria" class="form-control" required>
                            <option value="">Seleccione</option>
                            <?php foreach($categorias as $categoria):?>
                                <option value="<?php echo $categoria->id_categoria;?>"><?php echo $categoria->nombre;?></option>
                            <?php endforeach;?>
                        </select>
                    </div>
                    <div class="form-group">
                        <button type="submit" class="btn btn-success btn-flat">Guardar</button>
                        <a href="<?php echo base_url('inventario/productos');?>" class="btn btn-danger btn-flat">Volver</a>
                    </div>
                </form>
            </div>
        </div>
    </section>
</div>