<div class="content-wrapper">
    <section class="content-header">
        <h1>
            Movimientos de Inventario
            <small>Listado</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url();?>"><i class="fa fa-dashboard"></i> Inicio</a></li>
            <li><a href="<?php echo base_url('admin/inventario/dashboard');?>">Inventario</a></li>
            <li class="active">Movimientos</li>
        </ol>
    </section>
    
    <!-- Sección de resumen estadístico con espacio reducido -->
    <section class="content" style="padding-bottom: 0; min-height: 1px !important;">
        <div class="row" id="estadisticas-container">
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-aqua" style="overflow: hidden; height: 100px;">
                    <div class="inner">
                        <h3 id="total-entradas"><?php echo isset($estadisticas['total_entradas']) ? $estadisticas['total_entradas'] : 0; ?></h3>
                        <p>Total Entradas</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-sign-in"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red" style="overflow: hidden; height: 100px;">
                    <div class="inner">
                        <h3 id="total-salidas"><?php echo isset($estadisticas['total_salidas']) ? $estadisticas['total_salidas'] : 0; ?></h3>
                        <p>Total Salidas</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-sign-out"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green" style="overflow: hidden; height: 100px;">
                    <div class="inner">
                        <h3 id="stock-afectado"><?php echo isset($estadisticas['stock_afectado']) ? $estadisticas['stock_afectado'] : 0; ?></h3>
                        <p>Stock Afectado</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-cubes"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow" style="overflow: hidden; height: 100px;">
                    <div class="inner">
                        <h3 id="producto-mas-movido" style="font-size: 18px; white-space: nowrap; text-overflow: ellipsis; overflow: hidden;"><?php echo isset($estadisticas['producto_mas_movido']) ? substr($estadisticas['producto_mas_movido'], 0, 15) : 'N/A'; ?></h3>
                        <p>Producto Más Movido</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-star"></i>
                    </div>
                </div>
            </div>
        </div>
    </section>
            
    <section class="content" style="padding-top: 0;">
        <div class="box">
            <div class="box-header">
                <h3 class="box-title">Lista de Movimientos</h3>
                <div class="box-tools">
                    <a href="<?php echo base_url('admin/inventario/movimientos/add');?>" class="btn btn-primary btn-flat"><i class="fa fa-plus"></i> Registrar Movimiento</a>
                </div>
            </div>
            
            <!-- Filtros de búsqueda -->
            <div class="box-body">
                <div class="row">
                    <div class="col-md-12">
                        <form id="form-filtros" class="form-inline">
                            <div class="form-group">
                                <label for="fecha_inicio">Desde:</label>
                                <input type="date" class="form-control" id="fecha_inicio" name="fecha_inicio">
                            </div>
                            <div class="form-group">
                                <label for="fecha_fin">Hasta:</label>
                                <input type="date" class="form-control" id="fecha_fin" name="fecha_fin">
                            </div>
                            <div class="form-group">
                                <label for="tipo_movimiento">Tipo:</label>
                                <select class="form-control" id="tipo_movimiento" name="tipo_movimiento">
                                    <option value="">Todos</option>
                                    <option value="entrada">Entrada</option>
                                    <option value="salida">Salida</option>
                                    <option value="ajuste">Ajuste</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="producto">Producto:</label>
                                <select class="form-control select2" id="producto" name="producto">
                                    <option value="">Todos</option>
                                    <?php if(isset($productos)): ?>
                                        <?php foreach($productos as $producto): ?>
                                            <option value="<?php echo $producto->id_producto; ?>"><?php echo $producto->nombre; ?></option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="usuario">Usuario:</label>
                                <select class="form-control" id="usuario" name="usuario">
                                    <option value="">Todos</option>
                                    <?php if(isset($usuarios)): ?>
                                        <?php foreach($usuarios as $usuario): ?>
                                            <option value="<?php echo $usuario->codi_usu; ?>"><?php echo $usuario->nomb_usu; ?></option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <button type="button" id="btn-filtrar" class="btn btn-default"><i class="fa fa-search"></i> Filtrar</button>
                            <button type="button" id="btn-reset" class="btn btn-warning"><i class="fa fa-refresh"></i> Limpiar</button>
                        </form>
                    </div>
                </div>
                <hr>
                <!-- Búsqueda rápida -->
                <div class="row">
                    <div class="col-md-6">
                        <div class="input-group">
                            <input type="text" class="form-control" id="busqueda_rapida" placeholder="Buscar por nombre o código de producto...">
                            <span class="input-group-btn">
                                <button type="button" id="btn-buscar" class="btn btn-info btn-flat"><i class="fa fa-search"></i></button>
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="box-body">
                <div id="tabla-container">
                    <table id="tabla-movimientos" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Fecha</th>
                                <th>Tipo</th>
                                <th>Producto</th>
                                <th>Cantidad</th>
                                <th>Usuario</th>
                                <th>Observación</th>
                            </tr>
                        </thead>
                        <tbody id="tabla-movimientos-body">
                            <?php if(!empty($movimientos)):?>
                                <?php foreach($movimientos as $movimiento):?>
                                    <tr>
                                        <td><?php echo $movimiento->id_movimiento;?></td>
                                        <td><?php echo $movimiento->fecha_movimiento;?></td>
                                        <td><?php echo $movimiento->tipo_movimiento;?></td>
                                        <td><?php echo $movimiento->producto;?></td>
                                        <td><?php echo $movimiento->cantidad;?></td>
                                        <td><?php echo $movimiento->usuario;?></td>
                                        <td><?php echo $movimiento->observaciones;?></td>
                                    </tr>
                                <?php endforeach;?>
                            <?php endif;?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
$(document).ready(function() {
    // Variable para almacenar la instancia de DataTable
    var tabla;
    
    // Inicializar Select2 para mejorar la selección de productos
    $('.select2').select2({
        placeholder: "Seleccione un producto",
        allowClear: true
    });
    
    // Inicializar DataTable con paginación y búsqueda
    inicializarDataTable();
    
    function inicializarDataTable() {
        if ($.fn.DataTable.isDataTable('#tabla-movimientos')) {
            $('#tabla-movimientos').DataTable().destroy();
        }
        
        tabla = $("#tabla-movimientos").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "pageLength": 10,
            "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Todos"]],
            "order": [[0, "desc"]], // Ordenar por ID de forma descendente
            "language": {
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "zeroRecords": "No se encontraron resultados",
                "info": "Mostrando página _PAGE_ de _PAGES_",
                "infoEmpty": "No hay registros disponibles",
                "infoFiltered": "(filtrado de _MAX_ registros totales)",
                "search": "Buscar:",
                "paginate": {
                    "first": "Primero",
                    "last": "Último",
                    "next": "Siguiente",
                    "previous": "Anterior"
                }
            }
        });
    }
    
    // Función para actualizar las estadísticas
    function actualizarEstadisticas() {
        $.ajax({
            url: '<?php echo base_url("admin/inventario/get_estadisticas_movimientos"); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                $('#total-entradas').text(data.total_entradas);
                $('#total-salidas').text(data.total_salidas);
                $('#stock-afectado').text(data.stock_afectado);
                $('#producto-mas-movido').text(data.producto_mas_movido ? data.producto_mas_movido.substring(0, 15) : 'N/A');
            },
            error: function(xhr, status, error) {
                console.error("Error al actualizar estadísticas:", error);
            }
        });
    }
    
    // Filtrar movimientos con AJAX
    $('#btn-filtrar').on('click', function() {
        filtrarMovimientos();
    });
    
    function filtrarMovimientos() {
        var formData = $('#form-filtros').serialize();
        
        $.ajax({
            url: '<?php echo base_url("admin/inventario/filtrar_movimientos"); ?>',
            type: 'POST',
            data: formData,
            dataType: 'json',
            beforeSend: function() {
                // Mostrar indicador de carga
                $('#tabla-container').append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
            },
            success: function(data) {
                // Actualizar estadísticas
                $('#total-entradas').text(data.estadisticas.total_entradas);
                $('#total-salidas').text(data.estadisticas.total_salidas);
                $('#stock-afectado').text(data.estadisticas.stock_afectado);
                $('#producto-mas-movido').text(data.estadisticas.producto_mas_movido ? data.estadisticas.producto_mas_movido.substring(0, 15) : 'N/A');
                
                // Actualizar tabla
                actualizarTablaMovimientos(data.movimientos);
            },
            error: function(xhr, status, error) {
                console.error("Error al filtrar movimientos:", error);
                alert("Error al filtrar los datos. Por favor, inténtelo de nuevo.");
            },
            complete: function() {
                // Quitar indicador de carga
                $('#tabla-container .overlay').remove();
            }
        });
    }
    
    // Función para actualizar la tabla de movimientos
    function actualizarTablaMovimientos(movimientos) {
        // Destruir DataTable existente
        if ($.fn.DataTable.isDataTable('#tabla-movimientos')) {
            $('#tabla-movimientos').DataTable().destroy();
        }
        
        // Limpiar y actualizar el cuerpo de la tabla
        var tbody = $('#tabla-movimientos-body');
        tbody.empty();
        
        if (movimientos && movimientos.length > 0) {
            $.each(movimientos, function(index, movimiento) {
                var row = '<tr>' +
                    '<td>' + movimiento.id_movimiento + '</td>' +
                    '<td>' + movimiento.fecha_movimiento + '</td>' +
                    '<td>' + movimiento.tipo_movimiento + '</td>' +
                    '<td>' + movimiento.producto + '</td>' +
                    '<td>' + movimiento.cantidad + '</td>' +
                    '<td>' + movimiento.usuario + '</td>' +
                    '<td>' + movimiento.observaciones + '</td>' +
                    '</tr>';
                tbody.append(row);
            });
        } else {
            tbody.append('<tr><td colspan="7" class="text-center">No se encontraron movimientos</td></tr>');
        }
        
        // Reinicializar DataTable
        inicializarDataTable();
    }
    
    // Limpiar filtros
    $('#btn-reset').on('click', function() {
        $('#form-filtros')[0].reset();
        $('.select2').val('').trigger('change');
        
        // Recargar todos los datos
        window.location.reload();
    });
    
    // Búsqueda rápida
    $('#btn-buscar').on('click', function() {
        var busqueda = $('#busqueda_rapida').val();
        tabla.search(busqueda).draw();
    });
    
    // Búsqueda rápida al presionar Enter
    $('#busqueda_rapida').on('keyup', function(e) {
        if (e.keyCode === 13) {
            tabla.search(this.value).draw();
        }
    });
    
    // Actualizar estadísticas cada 30 segundos
    setInterval(actualizarEstadisticas, 30000);
});
</script>
