<div class="content-wrapper">
    <section class="content-header">
        <h1>
            Movimientos de Inventario
            <small>Nuevo</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url();?>"><i class="fa fa-dashboard"></i> Inicio</a></li>
            <li><a href="<?php echo base_url('admin/inventario/movimientos');?>">Movimientos</a></li>
            <li class="active">Nuevo</li>
        </ol>
    </section>

    <section class="content">
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title">Nuevo Movimiento</h3>
            </div>
            <form action="<?php echo base_url('admin/inventario/movimientos/store');?>" method="POST" class="form-horizontal">
                <div class="box-body">
                    <div class="form-group">
                        <label class="col-md-3 control-label">Fecha:</label>
                        <div class="col-md-3">
                            <input type="datetime-local" class="form-control" name="fecha_movimiento" value="<?php echo date("Y-m-d\TH:i");?>" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label">Tipo de Movimiento:</label>
                        <div class="col-md-4">
                            <select name="tipo_movimiento" class="form-control" required>
                                <option value="">Seleccione</option>
                                <option value="entrada">Entrada</option>
                                <option value="salida">Salida</option>
                                <option value="ajuste">Ajuste de Inventario</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label">Producto:</label>
                        <div class="col-md-6">
                            <select name="producto" id="producto" class="form-control select2" required>
                                <option value="">Seleccione</option>
                                <?php foreach($productos as $producto):?>
                                    <option value="<?php echo $producto->id_producto;?>"><?php echo $producto->codigo." - ".$producto->nombre;?></option>
                                <?php endforeach;?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label">Cantidad:</label>
                        <div class="col-md-3">
                            <input type="number" class="form-control" name="cantidad" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label">Observación:</label>
                        <div class="col-md-6">
                            <textarea name="observaciones" class="form-control" rows="3"></textarea>
                        </div>
                    </div>
                </div>
                <div class="box-footer">
                    <div class="form-group">
                        <div class="col-md-9 col-md-offset-3">
                            <button type="submit" class="btn btn-primary btn-flat">Guardar</button>
                            <a href="<?php echo base_url('admin/inventario/movimientos');?>" class="btn btn-danger btn-flat">Cancelar</a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </section>
</div>