<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Reporte de Compras</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
        }
        h1 {
            text-align: center;
            font-size: 16px;
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
    </style>
</head>
<body>
    <h1>Reporte de Compras (<?php echo $fecha_inicio; ?> - <?php echo $fecha_fin; ?>)</h1>
    
    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Fecha</th>
                <th>Proveedor</th>
                <th>Comprobante</th>
                <th>Total</th>
                <th>Estado</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($compras as $compra): ?>
                <tr>
                    <td><?php echo $compra->id_compra; ?></td>
                    <td><?php echo $compra->fecha; ?></td>
                    <td><?php echo $compra->proveedor; ?></td>
                    <td><?php echo $compra->comprobante; ?></td>
                    <td><?php echo number_format($compra->total, 2); ?></td>
                    <td>
                        <?php if($compra->estado == "1"): ?>
                            Pendiente
                        <?php else: ?>
                            Anulado
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>