<div class="content-wrapper">
    <section class="content-header">
        <h1>
            Compras
            <small>Listado</small>
        </h1>
    </section>
    <section class="content">
        <!-- Mensajes de notificación temporales -->
        <div id="notifications-container" style="position: fixed; top: 20px; right: 20px; z-index: 9999; width: 350px;"></div>
        
        <!-- Filtro por rango de fechas -->
        <div class="box box-solid">
            <div class="box-header with-border">
                <h3 class="box-title">Filtrar por fechas</h3>
            </div>
            <div class="box-body">
                <form id="form-filter" class="form-inline">
                    <div class="form-group">
                        <label for="fecha_inicio">Desde:</label>
                        <input type="date" class="form-control" id="fecha_inicio" name="fecha_inicio">
                    </div>
                    <div class="form-group" style="margin-left: 10px;">
                        <label for="fecha_fin">Hasta:</label>
                        <input type="date" class="form-control" id="fecha_fin" name="fecha_fin">
                    </div>
                    <button type="button" id="btn-filter" class="btn btn-primary" style="margin-left: 10px;">
                        <i class="fa fa-search"></i> Filtrar
                    </button>
                    <div class="btn-group" style="margin-left: 10px;">
                        <button type="button" class="btn btn-success dropdown-toggle" data-toggle="dropdown">
                            <i class="fa fa-download"></i> Exportar <span class="caret"></span>
                        </button>
                        <ul class="dropdown-menu" role="menu">
                            <li><a href="#" id="export-excel"><i class="fa fa-file-excel-o"></i> Excel</a></li>
                            <li><a href="#" id="export-pdf"><i class="fa fa-file-pdf-o"></i> PDF</a></li>
                            <li><a href="#" id="export-print"><i class="fa fa-print"></i> Imprimir</a></li>
                        </ul>
                    </div>
                </form>
            </div>
        </div>

        <div class="box">
            <div class="box-header">
                <h3 class="box-title">Lista de Compras</h3>
                <div class="box-tools">
                    <a href="<?php echo base_url('admin/inventario/compras/add');?>" class="btn btn-primary btn-flat"><i class="fa fa-plus"></i> Nueva Compra</a>
                </div>
            </div>
            <div class="box-body">
                <table id="example1" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Fecha</th>
                            <th>Proveedor</th>
                            <th>Producto</th>
                            <th>Comprobante</th>
                            <th>Total</th>
                            <th>Estado</th>
                            <th>Opciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(!empty($compras)):?>
                            <?php foreach($compras as $compra):?>
                                <tr>
                                    <td><?php echo $compra->id_compra;?></td>
                                    <td><?php echo $compra->fecha;?></td>
                                    <td><?php echo $compra->proveedor;?></td>
                                    <td>
                                        <?php if(!empty($compra->productos)): ?>
                                            <ul style="padding-left: 15px; margin-bottom: 0;">
                                                <?php foreach($compra->productos as $producto): ?>
                                                    <li><?php echo $producto->nombre; ?></li>
                                                <?php endforeach; ?>
                                            </ul>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo $compra->comprobante;?></td>
                                    <td><?php echo number_format($compra->total, 2);?></td>
                                    <!-- En la sección donde se muestra el estado, asegúrate de que esté así: -->
                                    <!-- Corregir la visualización del estado basado en valores ENUM -->
                                                                    <td>
                                                                        <?php 
                                                                        // Descomentar para depuración
                                                                        // echo "Valor del estado: " . var_export($compra->estado, true) . " - Tipo: " . gettype($compra->estado) . "<br>"; 
                                                                        ?>
                                                                        
                                                                        <?php if($compra->estado == "pendiente"): ?>
                                                                            <span class="label label-success">Pendiente</span>
                                                                        <?php elseif($compra->estado == "recibida"): ?>
                                                                            <span class="label label-info">Recibida</span>
                                                                        <?php else: ?>
                                                                            <span class="label label-danger">Anulado</span>
                                                                        <?php endif;?>
                                                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-info btn-view-compra" value="<?php echo $compra->id_compra;?>" data-toggle="modal" data-target="#modal-default"><i class="fa fa-eye"></i></button>
                                            <?php if($compra->estado == "pendiente"): ?>
                                                <a href="<?php echo base_url('admin/inventario/recibir_compra/'.$compra->id_compra);?>" class="btn btn-success btn-flat" title="Marcar como recibida"><i class="fa fa-check"></i></a>
                                                <a href="<?php echo base_url('admin/inventario/compras/anular/'.$compra->id_compra);?>" class="btn btn-danger btn-flat" title="Anular compra"><i class="fa fa-times"></i></a>
                                            <?php endif;?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach;?>
                        <?php endif;?>
                    </tbody>
                </table>
            </div>
        </div>
    </section>
</div>

<div class="modal fade" id="modal-default">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Información de la Compra</h4>
            </div>
            <div class="modal-body">
                
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger pull-left" data-dismiss="modal">Cerrar</button>
                <div class="btn-group">
                    <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                        <i class="fa fa-download"></i> Exportar <span class="caret"></span>
                    </button>
                    <ul class="dropdown-menu" role="menu">
                        <li><a href="#" class="btn-export-pdf"><i class="fa fa-file-pdf-o"></i> PDF</a></li>
                        <li><a href="#" class="btn-export-excel"><i class="fa fa-file-excel-o"></i> Excel</a></li>
                        <li><a href="#" class="btn-print"><i class="fa fa-print"></i> Imprimir</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal para exportar por rango de fechas -->
<div class="modal fade" id="modal-export">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Exportar Compras por Rango de Fechas</h4>
            </div>
            <div class="modal-body">
                <form id="form-export">
                    <div class="form-group">
                        <label for="export_fecha_inicio">Fecha Inicio:</label>
                        <input type="date" class="form-control" id="export_fecha_inicio" name="fecha_inicio" required>
                    </div>
                    <div class="form-group">
                        <label for="export_fecha_fin">Fecha Fin:</label>
                        <input type="date" class="form-control" id="export_fecha_fin" name="fecha_fin" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-success" id="btn-export-excel-range">Excel</button>
                <button type="button" class="btn btn-danger" id="btn-export-pdf-range">PDF</button>
                <button type="button" class="btn btn-info" id="btn-print-range">Imprimir</button>
            </div>
        </div>
    </div>
</div>

<!-- Add required libraries for export functionality -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.5/xlsx.full.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jQuery.print/1.6.0/jQuery.print.min.js"></script>

<script>
$(document).ready(function() {
    // Función para mostrar notificaciones temporales
    function showNotification(message, type) {
        var icon = type === 'success' ? 'fa-check' : 'fa-ban';
        var alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
        
        var notification = $('<div class="alert ' + alertClass + ' alert-dismissible fade in">' +
                            '<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>' +
                            '<p><i class="icon fa ' + icon + '"></i> ' + message + '</p>' +
                            '</div>');
        
        $('#notifications-container').append(notification);
        
        // Auto-cerrar después de 5 segundos
        setTimeout(function() {
            notification.alert('close');
        }, 2000);
    }
    
    // Mostrar notificaciones flash al cargar la página
    <?php if($this->session->flashdata("success")): ?>
    showNotification('<?php echo $this->session->flashdata("success"); ?>', 'success');
    <?php endif; ?>
    
    <?php if($this->session->flashdata("error")): ?>
    showNotification('<?php echo $this->session->flashdata("error"); ?>', 'error');
    <?php endif; ?>
    
    // Inicializar DataTable con botones de exportación
    var table = $("#example1").DataTable({
        "order": [[0, "desc"]], // Ordenar por ID (primera columna) de forma descendente
        "dom": 'Bfrtip',
        "buttons": [
            {
                extend: 'excel',
                text: '<i class="fa fa-file-excel-o"></i> Excel',
                className: 'btn btn-success',
                exportOptions: {
                    columns: [0, 1, 2, 4, 5, 6] // Excluir la columna de productos y opciones
                },
                title: 'Lista de Compras - MEDIDENT'
            },
            {
                extend: 'pdf',
                text: '<i class="fa fa-file-pdf-o"></i> PDF',
                className: 'btn btn-danger',
                exportOptions: {
                    columns: [0, 1, 2, 4, 5, 6] // Excluir la columna de productos y opciones
                },
                title: 'Lista de Compras - MEDIDENT',
                customize: function(doc) {
                    doc.content[1].table.widths = ['10%', '15%', '25%', '20%', '15%', '15%'];
                    doc.styles.tableHeader.fontSize = 12;
                    doc.defaultStyle.fontSize = 10;
                }
            },
            {
                extend: 'print',
                text: '<i class="fa fa-print"></i> Imprimir',
                className: 'btn btn-info',
                exportOptions: {
                    columns: [0, 1, 2, 4, 5, 6] // Excluir la columna de productos y opciones
                },
                title: 'Lista de Compras - MEDIDENT'
            }
        ],
        "language": {
            "lengthMenu": "Mostrar _MENU_ registros por página",
            "zeroRecords": "No se encontraron resultados",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "No hay registros disponibles",
            "infoFiltered": "(filtrado de _MAX_ registros totales)",
            "search": "Buscar:",
            "paginate": {
                "first": "Primero",
                "last": "Último",
                "next": "Siguiente",
                "previous": "Anterior"
            }
        }
    });
    
    // Ocultar los botones por defecto de DataTables
    $('.dt-buttons').hide();
    
    // Filtrar por rango de fechas
    $('#btn-filter').on('click', function() {
        var fechaInicio = $('#fecha_inicio').val();
        var fechaFin = $('#fecha_fin').val();
        
        if (fechaInicio && fechaFin) {
            // Convertir fechas a formato para comparación
            var inicio = new Date(fechaInicio);
            var fin = new Date(fechaFin);
            
            // Filtrar la tabla
            $.fn.dataTable.ext.search.push(
                function(settings, data, dataIndex) {
                    var fechaCompra = new Date(data[1]); // Columna de fecha
                    if (fechaCompra >= inicio && fechaCompra <= fin) {
                        return true;
                    }
                    return false;
                }
            );
            
            table.draw();
            
            // Limpiar el filtro después de aplicarlo
            $.fn.dataTable.ext.search.pop();
        } else {
            alert('Por favor, seleccione un rango de fechas completo');
        }
    });
    
    // Exportar a Excel la tabla filtrada
    $('#export-excel').on('click', function() {
        table.button('.buttons-excel').trigger();
    });
    
    // Exportar a PDF la tabla filtrada
    $('#export-pdf').on('click', function() {
        table.button('.buttons-pdf').trigger();
    });
    
    // Imprimir la tabla filtrada
    $('#export-print').on('click', function() {
        table.button('.buttons-print').trigger();
    });
    
    // Ver detalle de compra
    $(".btn-view-compra").on("click", function() {
        var id = $(this).val();
        $.ajax({
            url: base_url + "admin/inventario/compras/view",
            type: "POST",
            data: {id: id},
            success: function(resp) {
                $("#modal-default .modal-body").html(resp);
            }
        });
    });
    
    // Exportar detalle de compra a PDF
    $(".btn-export-pdf").on("click", function() {
        var contenido = $("#modal-default .modal-body").html();
        var compraId = $("#modal-default .modal-body").find('.compra-id').text();
        
        // Crear un elemento oculto para convertir a PDF
        var element = document.createElement('div');
        element.innerHTML = contenido;
        element.style.width = '700px';
        element.style.margin = '0 auto';
        
        // Usar html2pdf para generar el PDF
        html2pdf().from(element).set({
            margin: 10,
            filename: 'Compra_' + compraId + '.pdf',
            image: { type: 'jpeg', quality: 0.98 },
            html2canvas: { scale: 2, logging: true },
            jsPDF: { unit: 'mm', format: 'a4', orientation: 'portrait' }
        }).save();
    });
    
    // Exportar detalle de compra a Excel
    $(".btn-export-excel").on("click", function() {
        var compraId = $("#modal-default .modal-body").find('.compra-id').text();
        var tablaDetalle = $("#modal-default .modal-body table").clone();
        
        // Crear una tabla temporal para exportar
        var wb = XLSX.utils.table_to_book(tablaDetalle[0], {sheet: "Detalle Compra"});
        XLSX.writeFile(wb, 'Compra_' + compraId + '.xlsx');
    });
    
    // Imprimir detalle de compra
    $(".btn-print").on("click", function() {
        $("#modal-default .modal-body").print({
            title: "Detalle de Compra"
        });
    });
    
    // Exportar por rango de fechas - Controlador
    $('#btn-export-excel-range, #btn-export-pdf-range, #btn-print-range').on('click', function() {
        var fechaInicio = $('#export_fecha_inicio').val();
        var fechaFin = $('#export_fecha_fin').val();
        var tipo = '';
        
        if ($(this).attr('id') === 'btn-export-excel-range') {
            tipo = 'excel';
        } else if ($(this).attr('id') === 'btn-export-pdf-range') {
            tipo = 'pdf';
        } else {
            tipo = 'print';
        }
        
        if (fechaInicio && fechaFin) {
            window.location.href = base_url + 'admin/inventario/compras/exportar/' + tipo + '/' + fechaInicio + '/' + fechaFin;
            $('#modal-export').modal('hide');
        } else {
            alert('Por favor, seleccione un rango de fechas completo');
        }
    });
});
</script>