<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Categorías
            <small>Listado</small>
        </h1>
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="box">
            <div class="box-header">
                <h3 class="box-title">Lista de Categorías</h3>
                <div class="box-tools">
                    <a href="<?php echo base_url('inventario/add_categoria');?>" class="btn btn-primary"><i class="fa fa-plus"></i> Agregar Categoría</a>
                </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
                <table id="example1" class="table table-bordered table-striped">
                    <thead style="background:#3C8DBC; color:white;">
                        <tr>
                            <th>#</th>
                            <th>Nombre</th>
                            <th>Descripción</th>
                            <th>Opciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(!empty($categorias)):?>
                            <?php foreach($categorias as $categoria):?>
                                <tr>
                                    <td><?php echo $categoria->id_categoria;?></td>
                                    <td><?php echo $categoria->nombre;?></td>
                                    <td><?php echo $categoria->descripcion;?></td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="<?php echo base_url('inventario/edit_categoria/'.$categoria->id_categoria);?>" class="btn btn-warning"><i class="fa fa-pencil"></i></a>
                                            <a href="<?php echo base_url('inventario/delete_categoria/'.$categoria->id_categoria);?>" class="btn btn-danger btn-remove"><i class="fa fa-trash"></i></a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach;?>
                        <?php endif;?>
                    </tbody>
                </table>
            </div>
            <!-- /.box-body -->
        </div>
        <!-- /.box -->
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<script>
$(document).ready(function() {
    $("#example1").DataTable({
        "order": [[0, "desc"]], // Ordenar por ID (primera columna) de forma descendente
        "language": {
            "lengthMenu": "Mostrar _MENU_ registros por página",
            "zeroRecords": "No se encontraron resultados",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "No hay registros disponibles",
            "infoFiltered": "(filtrado de _MAX_ registros totales)",
            "search": "Buscar:",
            "paginate": {
                "first": "Primero",
                "last": "Último",
                "next": "Siguiente",
                "previous": "Anterior"
            }
        }
    });
});
</script>