<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>AdminLTE 2 | User Profile</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

  <script src="<?= base_url() ?>assets/plugins/calendar/js/calendar.js"></script>
  <script src="<?= base_url() ?>assets/plugins/calendar/js/underscore-min.js"></script>
  <script src="<?= base_url() ?>assets/plugins/calendar/js/language/es-ES.js"></script>

  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
</head>
<body class="hold-transition skin-blue sidebar-mini">


<style>
  /* Estilo personalizado para el campo de fecha */
.fecha-estilo {
  border-radius: 8px; /* Bordes redondeados */
  padding: 10px 15px; /* Espaciado interno para mayor comodidad */
  font-size: 16px; /* Tamaño de la fuente */
  border: 1px solid #ccc; /* Borde gris claro */
  background-color: #f9f9f9; /* Fondo claro */
  color: #333; /* Color de texto */
  box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1); /* Sombra suave para el campo */
  transition: all 0.3s ease; /* Transición suave para los efectos */
}

/* Efecto cuando el campo está enfocado (se hace clic en él) */
.fecha-estilo:focus {
  border-color: #007bff; /* Cambio de borde al azul al hacer clic */
  background-color: #ffffff; /* Fondo blanco al hacer clic */
  box-shadow: 0 0 10px rgba(0, 123, 255, 0.3); /* Sombra azul */
  outline: none; /* Elimina el contorno predeterminado */
}

/* Efecto cuando el campo tiene un valor */
.fecha-estilo::placeholder {
  color: #999; /* Color del placeholder */
}

/* Efecto hover para una mejor interacción */
.fecha-estilo:hover {
  border-color: #0056b3; /* Cambio de color del borde cuando el mouse está encima */
}

</style>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
       <i class="fa fa-calendar"></i> Agenda
      </h1>
    
    </section>

    <!-- Main content -->
    <section class="content">
      
      <div class="row">
        <div class="col-md-3">

          <!-- Profile Image -->
          <div class="box box-primary">
            <div class="box-body box-profile">
               <form id="FormAgendaFiltro" autocomplete="off">
               <div class="row">
                    <div class="col-md-12">
                      <div class="form-group grupo">
                      <input type="text" name="fecha" class="form-control fecha-estilo" id="fecha" placeholder="Selecciona una fecha">
                      </div>
                    </div>
               </div>
                    <div class="row">
                    <div class="col-md-12">
                      <div class="form-group">
                        <label class="control-label">Especialidad</label>
                        <select name="especialidad" class="form-control input-sm filtrarMedicos" style="width: 100%;" tabindex="-1" aria-hidden="true">
                          <option value="">Seleccione</option>
                          <?php foreach ($especialidad as $e): ?>
                            <option value="<?= $e->cod_especialidad ?>"><?= $e->nombre_especialidad ?></option>
                          <?php endforeach ?>
                        </select>
                      </div>
                    </div>
                  </div>

 
                         <div class="row">
                    <div class="col-md-12">
                      <div class="form-group">
                        <label class="control-label">Médico</label>
                        <select name="medico" class="form-control input-sm" style="width: 100%;" tabindex="-1" aria-hidden="true">
                          
                        </select>
                      </div>
                    </div>
                  </div>
              
   
                         <div class="row">
                    <div class="col-md-12">
                      <label class="control-label">Estado</label>
                      <div class="form-group">
                        <select name="estado" class="form-control input-sm" style="width: 100%;" tabindex="-1" aria-hidden="true">
                        <option value="">Todos</option>
                        <?php foreach ($estados as $o): ?>
                        <option value="<?= $o->cod_citado ?>"><?= $o->nomb_citado ?></option>
                        <?php endforeach ?>
                        </select>
                      </div>
                    </div>
                  </div>

             <div class="row">
                    <div class="col-md-12">
                      <button type="submit" class="btn btn-block btn-primary"> Buscar</button>
                    </div>
                  </div>
  </form>
              <!-- <a href="#" class="btn btn-primary btn-block"><b>Follow</b></a> -->
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->

        </div>
        <!-- /.col -->
        <div class="col-md-9">
           <div class="box box-primary collapsed-box">
             <div class="box-header with-border">
                       <div class="row">
                  <div class="col-md-12">
                    <div class="botones">
                      <div class="btn-group">
                        <button class="btn btn-primary" data-calendar-nav="prev"><i class="fa fa-fw fa-chevron-left"></i></button>
                        <button class="btn btn-default" data-calendar-nav="today">Hoy</button>
                        <button class="btn btn-primary" data-calendar-nav="next"><i class="fa fa-fw fa-chevron-right"></i></button>
                      </div>
                      <h4></h4>
                      <div class="form-group">
                      <div class="radio-inline">
                        <label class="checkbox">
                          <input type="radio" name="vista" value="year" data-calendar-view="year"> Año
                        </label>
                      </div>
                      <div class="radio-inline">
                        <label class="checkbox">
                          <input type="radio" name="vista" value="month" data-calendar-view="month"> Mes
                        </label>
                      </div>
                      <div class="radio-inline">
                        <label class="checkbox">
                          <input type="radio" name="vista" value="week" data-calendar-view="week"> Semana
                        </label>
                      </div>
                      <div class="radio-inline">
                        <label class="checkbox">
                          <input type="radio" name="vista" value="day" data-calendar-view="day" checked> Día
                        </label>
                      </div>
                    </div>
                    </div>
                    
                  </div>
                </div>
                <div id="calendar"></div>
        </div>
      </div>
          <!-- /.nav-tabs-custom -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
  
    </section>
    <!-- /.content -->
  </div>

<div class="modal fade" id="events-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-sm">
      <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
          <h3 class="modal-title"></h3>
        </div>
        <div class="modal-body">
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
        </div>
      </div>
    </div>
  </div>


  
<!-- Asegúrate de que estos scripts estén en el orden correcto (primero Flatpickr, luego la localización) -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/l10n/es.js"></script>

<script>
  document.addEventListener('DOMContentLoaded', function() {
    // Configuración del calendario en español
    flatpickr("#fecha", {
      locale: "es",            // Establece el idioma español
      dateFormat: "Y-m-d",     // Formato de fecha (Año-Mes-Día)
      maxDate: "2030-12-31",   // Fecha máxima
      minDate: "",   // Fecha mínima
      allowInput: true,        // Permite que el usuario escriba la fecha manualmente
      disableMobile: false,    // Habilita el selector de fecha nativo en móviles si es necesario
      altInput: false,         // Genera un campo visible adicional con formato más amigable
      altFormat: "d/m/Y",      // Formato visual (día/mes/año)
      defaultDate: new Date(), // Establece la fecha actual como la fecha por defecto
      // Esta opción asegura que el calendario se muestre en el mes actual, no en enero
      onOpen: function(selectedDates, dateStr, instance) {
        instance.setDate(new Date(), true); // Establece la fecha seleccionada al abrir
      }
    });
    
    // Si también necesitas inicializar el datepicker en el modal de editar cita
    flatpickr(".datepicker", {
      locale: "es",
      dateFormat: "Y-m-d",
      altInput: true,
      altFormat: "d/m/Y",
      defaultDate: new Date(),  // Establece la fecha actual como la fecha por defecto
      onOpen: function(selectedDates, dateStr, instance) {
        instance.setDate(new Date(), true); // Establece la fecha seleccionada al abrir
      }
    });
    
    // Para el selector de hora en el modal
    flatpickr(".timepicker", {
      locale: "es",
      enableTime: true,
      noCalendar: true,
      dateFormat: "H:i",
      time_24hr: true
    });
  });
</script>
</body>
</html>
