<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Sedes_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        
    }

    // Obtener todas las sedes
    public function get_sedes() {
        return $this->db->get('sede')->result();  // Seleccionamos todas las sedes
    }

    // Insertar una nueva sede
    public function insert_sede($data) {
        $this->db->insert('sede', $data);  // Insertar los datos de la nueva sede
    }

    // Obtener una sede por ID
    public function get_sede_by_id($id) {
        return $this->db->get_where('sede', ['cod_sede' => $id])->row();
    }

    // Actualizar una sede
    public function update_sede($id, $data) {
        $this->db->where('cod_sede', $id);
        return $this->db->update('sede', $data);
    }

    // Eliminar una sede
    public function delete_sede($id) {
        $this->db->where('cod_sede', $id);  // Condición para buscar la sede por su ID
        $this->db->delete('sede');  // Eliminar la sede
    }
}
