<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Inventario_model extends CI_Model {
    
    public function get_productos_stock_bajo() {
        $this->db->where('stock_actual <= stock_minimo');
        return $this->db->get('inv_productos')->result();
    }

    public function get_total_productos() {
        return $this->db->count_all('inv_productos');
    }

    public function get_total_proveedores() {
        return $this->db->count_all('inv_proveedores');
    }

    public function get_productos() {
        $this->db->select('p.*, c.nombre as categoria, m.nombre as marca');
        $this->db->from('inv_productos p');
        $this->db->join('inv_categorias c', 'c.id_categoria = p.id_categoria', 'left');
        $this->db->join('inv_marcas m', 'm.id_marca = p.id_marca', 'left');
        return $this->db->get()->result();
    }
}