<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class DoctorPdf_model extends CI_Model {
    
    private $pdf_directory;
    
    public function __construct() {
        parent::__construct();
        $this->pdf_directory = FCPATH . 'application/pdfs/doctor/';
        $this->ensure_directory_exists();
    }
    
    private function ensure_directory_exists() {
        if (!is_dir($this->pdf_directory)) {
            @mkdir($this->pdf_directory, 0755, true);
        }
        
        // Crear archivo .htaccess para proteger el directorio
        $htaccess_path = $this->pdf_directory . '.htaccess';
        if (!file_exists($htaccess_path)) {
            $htaccess_content = "Order Deny,Allow\nDeny from all";
            @file_put_contents($htaccess_path, $htaccess_content);
        }
    }
    
    public function get_all_pdfs() {
        $pdfs = [];
        
        if (!is_dir($this->pdf_directory)) {
            return $pdfs;
        }
        
        $files = scandir($this->pdf_directory);
        
        foreach ($files as $file) {
            if (pathinfo($file, PATHINFO_EXTENSION) === 'pdf') {
                $pdfs[] = $file;
            }
        }
        
        // Ordenar alfabéticamente
        sort($pdfs);
        
        return $pdfs;
    }
    
    public function get_pdf_path($filename) {
        // Validar filename antes de construir path
        $filename = basename($filename);
        return $this->pdf_directory . $filename;
    }
}