<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Compras_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->table = 'inv_compras';
        $this->table_detalle = 'inv_detalle_compras';
    }

    public function getCompras() {
        $this->db->select('c.id_compra, c.fecha_compra as fecha, p.razon_social as proveedor, c.factura_nro as comprobante, c.total, c.estado');
        $this->db->from($this->table . ' c');
        $this->db->join('inv_proveedores p', 'p.id_proveedor = c.id_proveedor');
        // $this->db->where('c.estado', '1'); // Comentado para ver todas las compras
        $resultados = $this->db->get();
        $compras = $resultados->result();
        
        // Obtener los productos para cada compra
        foreach ($compras as $compra) {
            $compra->productos = $this->getProductosCompra($compra->id_compra);
            // Asegurarse de que el estado sea un string para comparaciones consistentes
            $compra->estado = (string)$compra->estado;
        }
        
        return $compras;
    }

    public function getComprasByDateRange($fecha_inicio, $fecha_fin) {
        $this->db->select('c.*, p.razon_social as proveedor');
        $this->db->from($this->table . ' c');
        $this->db->join('inv_proveedores p', 'c.id_proveedor = p.id_proveedor');
        $this->db->where('DATE(c.fecha_compra) >=', $fecha_inicio);
        $this->db->where('DATE(c.fecha_compra) <=', $fecha_fin);
        $this->db->order_by('c.id_compra', 'DESC');
        $resultados = $this->db->get();
        
        if ($resultados->num_rows() > 0) {
            $compras = $resultados->result();
            
            foreach ($compras as $compra) {
                $compra->productos = $this->getProductosCompra($compra->id_compra);
            }
            
            return $compras;
        } else {
            return array();
        }
    }

    public function getProductosCompra($id_compra) {
        $this->db->select('dc.*, p.nombre');
        $this->db->from($this->table_detalle . ' dc');
        $this->db->join('inv_productos p', 'dc.id_producto = p.id_producto');
        $this->db->where('dc.id_compra', $id_compra);
        $resultados = $this->db->get();
        
        return $resultados->result();
    }

    public function getCompra($id) {
        $this->db->select('c.*, p.razon_social as proveedor');
        $this->db->from($this->table . ' c');
        $this->db->join('inv_proveedores p', 'p.id_proveedor = c.id_proveedor');
        $this->db->where('c.id_compra', $id);
        $resultado = $this->db->get();
        return $resultado->row();
    }

    public function save($data) {
        return $this->db->insert($this->table, $data);
    }

    public function update($id, $data) {
        $this->db->where('id_compra', $id);
        return $this->db->update($this->table, $data);
    }

    public function lastID() {
        return $this->db->insert_id();
    }

    public function save_detalle($data) {
        return $this->db->insert($this->table_detalle, $data);
    }

    public function getDetalle($id) {
        $this->db->select('d.*, p.nombre as producto');
        $this->db->from($this->table_detalle . ' d');
        $this->db->join('inv_productos p', 'p.id_producto = d.id_producto');
        $this->db->where('d.id_compra', $id);
        $resultados = $this->db->get();
        return $resultados->result();
    }
}