<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Sedes extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('sedes_model');
    }

    // Mostrar la lista de sedes
    public function index() {
        $data['sedes'] = $this->sedes_model->get_sedes();
        $this->load->view('layouts/header');
        $this->load->view('layouts/aside');
        $this->load->view('mantenimiento/sedes', $data);  // Vista que lista las sedes
        $this->load->view('layouts/footer');
    }

    // Crear una nueva sede
    public function create() {
        $this->load->view('layouts/header');
        $this->load->view('layouts/aside');
        $this->load->view('mantenimiento/create_sede');  // Vista para crear una sede
        $this->load->view('layouts/footer');
    }

    // Guardar una nueva sede
    public function store() {
        $this->form_validation->set_rules('nombre', 'Nombre', 'required');
        $this->form_validation->set_rules('estado', 'Estado', 'required');

        if ($this->form_validation->run() == TRUE) {
            $data = [
                'nombre_sede' => $this->input->post('nombre'),
                'estado_sede' => $this->input->post('estado')
            ];
            $this->sedes_model->insert_sede($data);
            $this->session->set_flashdata('success', 'La sede ha sido creada exitosamente.');
            redirect('mantenimiento/sedes');  // Redirigir después de guardar
        } else {
            $this->create();  // Volver al formulario en caso de error
        }
    }

    // Editar una sede
    public function edit($id) {
        // Validar que el ID existe y es válido
        $data['sede'] = $this->sedes_model->get_sede_by_id($id);  // Obtener los detalles de la sede
        $this->load->view('layouts/header');
        $this->load->view('layouts/aside');
        $this->load->view('mantenimiento/edit_sede', $data);  // Vista para editar la sede
        $this->load->view('layouts/footer');
    }
    

    // Actualizar una sede
    public function update($id) {
        $data = array(
            'nombre_sede' => $this->input->post('nombre'),
            'estado_sede' => $this->input->post('estado')
        );
        
        $this->sedes_model->update_sede($id, $data);
        $this->session->set_flashdata('success', 'La sede ha sido Actualizada exitosamente.');
        redirect('mantenimiento/sedes');
    }

    // Eliminar una sede
    public function delete($id) {
        $this->sedes_model->delete_sede($id);
        $this->session->set_flashdata('success', 'La sede ha sido Eliminada exitosamente.');
        redirect('mantenimiento/sedes');  // Redirigir a la lista después de eliminar
    }

}
