<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class DoctorPdf extends CI_Controller {
    public function __construct() {
        parent::__construct();
        if(!$this->session->userdata("login")){
            redirect(base_url());
        }
        $this->load->model('DoctorPdf_model'); // Cargar el modelo
    }

    public function index() {
        $data['pdfs'] = $this->DoctorPdf_model->get_all_pdfs(); // Usar el modelo
        $this->load->view('layouts/header');
        $this->load->view('layouts/aside');
        $this->load->view('doctor/lista_pdfs1.php', $data);
        $this->load->view('layouts/footer');
    }

    public function ver($filename) {
        $filepath = $this->DoctorPdf_model->get_pdf_path($filename); // Usar el modelo
        if (file_exists($filepath)) {
            header('Content-type: application/pdf');
            header('Content-Disposition: inline; filename="' . $filename . '"');
            readfile($filepath);
        } else {
            show_404();
        }
    }
}