<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Productos extends CI_Controller {

    public function __construct() {
        parent::__construct();
        if (!$this->session->userdata("login")) {
            redirect(base_url());
        }
        $this->load->model("Productos_model");
        $this->load->model("Categorias_model");
        $this->load->model("Movimientos_model");
    }

    public function desactivar($id_producto) {
        // Verificar que el producto existe
        $producto = $this->Productos_model->getProducto($id_producto);
        
        if (!$producto) {
            $this->session->set_flashdata("error", "El producto no existe");
            redirect(base_url('admin/inventario/productos'));
            return;
        }
        
        $data = array(
            'estado' => "0"
        );
        
        if ($this->Productos_model->update($id_producto, $data)) {
            $this->session->set_flashdata("success", "El producto ha sido desactivado correctamente");
        } else {
            $this->session->set_flashdata("error", "No se pudo desactivar el producto");
        }
        
        redirect(base_url('admin/inventario/productos'));
    }
    
    public function activar($id_producto) {
        // Verificar que el producto existe
        $producto = $this->Productos_model->getProducto($id_producto);
        
        if (!$producto) {
            $this->session->set_flashdata("error", "El producto no existe");
            redirect(base_url('admin/inventario/productos'));
            return;
        }
        
        $data = array(
            'estado' => "1"
        );
        
        if ($this->Productos_model->update($id_producto, $data)) {
            $this->session->set_flashdata("success", "El producto ha sido activado correctamente");
        } else {
            $this->session->set_flashdata("error", "No se pudo activar el producto");
        }
        
        redirect(base_url('admin/inventario/productos'));
    }
    
    // Add other methods as needed
    /**
     * Muestra el historial de movimientos de un producto
     * @param int $id_producto ID del producto
     */
    public function historial($id_producto) {
        // Cargar modelos necesarios
        $this->load->model('Movimientos_model');
        $this->load->model('Productos_model');
        
        // Obtener datos del producto
        $producto = $this->Productos_model->getProducto($id_producto);
        
        if (!$producto) {
            show_error('El producto no existe');
        }
        
        // Obtener movimientos del producto
        $movimientos = $this->Movimientos_model->getMovimientosPorProducto($id_producto);
        
        // Preparar datos para la vista
        $data = array(
            'producto' => $producto,
            'movimientos' => $movimientos
        );
        
        // Cargar vistas
        $this->load->view('layouts/header');
        $this->load->view('layouts/aside');
        $this->load->view('admin/productos/historial', $data);
        $this->load->view('layouts/footer');
    }
    
    public function bajos_stock() {
        // Obtener productos con stock bajo
        $productos = $this->Productos_model->getProductosBajosStock();
        
        $data = array(
            'productos' => $productos
        );
        
        $this->load->view('layouts/header');
        $this->load->view('layouts/aside');
        $this->load->view('admin/inventario/productos/bajos_stock', $data);
        $this->load->view('layouts/footer');
    }
}