<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ProductosFilter extends CI_Controller {

    public function __construct() {
        parent::__construct();
        if (!$this->session->userdata("login")) {
            redirect(base_url());
        }
        $this->load->model(array(
            'Productos_model',
            'Categorias_model'
        ));
    }

    /**
     * Método para filtrar productos vía AJAX
     */
    public function filtrar() {
        // Verificar si es una solicitud AJAX
        if (!$this->input->is_ajax_request()) {
            show_404();
            return;
        }
        
        try {
            // Obtener parámetros de filtro
            $categoria = $this->input->post('categoria');
            $estado = $this->input->post('estado');
            $stock = $this->input->post('stock');
            
            // Depuración
            log_message('debug', 'Filtros de productos: ' . json_encode([
                'categoria' => $categoria,
                'estado' => $estado,
                'stock' => $stock
            ]));
            
            // Obtener productos filtrados
            $productos = $this->Productos_model->filtrarProductos($categoria, $estado, $stock);
            
            // Preparar datos para la respuesta
            $data = array(
                'productos' => $productos,
                'status' => 'success'
            );
            
            // Devolver respuesta en formato JSON
            $this->output
                ->set_content_type('application/json')
                ->set_output(json_encode($data));
                
        } catch (Exception $e) {
            // Registrar el error
            log_message('error', 'Error en filtrar_productos: ' . $e->getMessage());
            
            // Devolver error
            $this->output
                ->set_status_header(500)
                ->set_content_type('application/json')
                ->set_output(json_encode(['error' => 'Error al filtrar los datos: ' . $e->getMessage()]));
        }
    }
    
    /**
     * Método para búsqueda rápida de productos
     */
    public function busqueda_rapida() {
        // Verificar si es una solicitud AJAX
        if (!$this->input->is_ajax_request()) {
            show_404();
            return;
        }
        
        try {
            $termino = $this->input->post('termino');
            
            // Obtener productos que coincidan con el término de búsqueda
            $productos = $this->Productos_model->buscarProductos($termino);
            
            // Preparar datos para la respuesta
            $data = array(
                'productos' => $productos,
                'status' => 'success'
            );
            
            // Devolver respuesta en formato JSON
            $this->output
                ->set_content_type('application/json')
                ->set_output(json_encode($data));
                
        } catch (Exception $e) {
            // Registrar el error
            log_message('error', 'Error en busqueda_rapida: ' . $e->getMessage());
            
            // Devolver error
            $this->output
                ->set_status_header(500)
                ->set_content_type('application/json')
                ->set_output(json_encode(['error' => 'Error al buscar productos: ' . $e->getMessage()]));
        }
    }
}