<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class DoctorPdf extends CI_Controller {
    public function __construct() {
        parent::__construct();
        if(!$this->session->userdata("login")){
            redirect(base_url());
        }
        $this->load->model('DoctorPdf_model');
        // $this->permisos = $this->backend_lib->control(); //<----aqui es
    }

    public function index() {
        $data['pdfs'] = $this->DoctorPdf_model->get_all_pdfs();
        $this->load->view('layouts/header');
        $this->load->view('layouts/aside');
        $this->load->view('doctor/lista_pdfs', $data);
        $this->load->view('layouts/footer');
    }

    public function ver($filename) {
        // Validaciones básicas de seguridad
        if (empty($filename)) {
            show_404();
            return;
        }
        
        // Eliminar path traversal attempts
        $filename = basename($filename);
        
        // Solo permitir archivos PDF
        if (!preg_match('/\.pdf$/i', $filename)) {
            show_404();
            return;
        }
        
        $filepath = $this->DoctorPdf_model->get_pdf_path($filename);
        
        // Verificar que el archivo existe y es legible
        if (!file_exists($filepath) || !is_readable($filepath)) {
            show_404();
            return;
        }
        
        // Ruta del logo
        $logo_path = 'assets/img/logovidadent2.png';
        
        // Verificar si el logo existe
        if (!file_exists(FCPATH . $logo_path)) {
            // Si no existe, intentar con otro logo
            $logo_path = 'assets/img/dentalsac.png';
            if (!file_exists(FCPATH . $logo_path)) {
                // Si tampoco existe, usar logo genérico
                $logo_path = 'assets/img/logo.jpg';
            }
        }
        
        // Crear una vista HTML que muestre el PDF con el logo superpuesto
        $data = [
            'pdf_url' => base_url('doctorpdf/raw_pdf/' . urlencode($filename)),
            'logo_url' => base_url($logo_path),
            'filename' => $filename
        ];
        
        $this->load->view('doctor/pdf_viewer', $data);
    }

    // Método para servir el PDF sin modificaciones (para el iframe)
    public function raw_pdf($filename) {
        // Validaciones básicas de seguridad
        if (empty($filename)) {
            show_404();
            return;
        }
        
        // Eliminar path traversal attempts
        $filename = basename($filename);
        
        // Solo permitir archivos PDF
        if (!preg_match('/\.pdf$/i', $filename)) {
            show_404();
            return;
        }
        
        $filepath = $this->DoctorPdf_model->get_pdf_path($filename);
        
        // Verificar que el archivo existe y es legible
        if (!file_exists($filepath) || !is_readable($filepath)) {
            show_404();
            return;
        }
        
        // Headers para mostrar el PDF en el navegador
        header('Content-Type: application/pdf');
        header('Content-Disposition: inline; filename="' . basename($filename) . '"');
        header('Content-Length: ' . filesize($filepath));
        
        // Limpiar cualquier output previo
        if (ob_get_level()) {
            ob_end_clean();
        }
        
        readfile($filepath);
        exit; // Importante: terminar la ejecución aquí
    }

    public function descargar($filename) {
        // Para la descarga, podemos mantener el método original ya que el usuario
        // descargará el PDF sin modificaciones
        // Validaciones básicas de seguridad
        if (empty($filename)) {
            show_404();
            return;
        }
        
        // Eliminar path traversal attempts
        $filename = basename($filename);
        
        // Solo permitir archivos PDF
        if (!preg_match('/\.pdf$/i', $filename)) {
            show_404();
            return;
        }
        
        $filepath = $this->DoctorPdf_model->get_pdf_path($filename);
        
        if (!file_exists($filepath) || !is_readable($filepath)) {
            show_404();
            return;
        }
        
        // Headers para forzar descarga
        header('Content-Type: application/pdf');
        header('Content-Disposition: attachment; filename="' . basename($filename) . '"');
        header('Content-Length: ' . filesize($filepath));
        
        // Limpiar cualquier output previo
        if (ob_get_level()) {
            ob_end_clean();
        }
        
        readfile($filepath);
        exit; // Importante: terminar la ejecución aquí
    }
}