<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'auth';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;


$route['admin/inventario/dashboard'] = 'admin/inventario/dashboard';
$route['admin/inventario/productos'] = 'admin/inventario/productos';
$route['admin/inventario/productos/add'] = 'admin/inventario/add_producto';
$route['admin/inventario/productos/store'] = 'admin/inventario/store_producto';
$route['admin/inventario/productos/edit/(:num)'] = 'admin/inventario/edit_producto/$1';
$route['admin/inventario/productos/update'] = 'admin/inventario/update_producto';
$route['admin/inventario/productos/delete/(:num)'] = 'admin/inventario/delete_producto/$1';

$route['admin/inventario/proveedores'] = 'admin/inventario/proveedores';
$route['admin/inventario/proveedores/add'] = 'admin/inventario/add_proveedor';
$route['admin/inventario/proveedores/store'] = 'admin/inventario/store_proveedor';
$route['admin/inventario/proveedores/edit/(:num)'] = 'admin/inventario/edit_proveedor/$1';
$route['admin/inventario/proveedores/update'] = 'admin/inventario/update_proveedor';
$route['admin/inventario/proveedores/delete/(:num)'] = 'admin/inventario/delete_proveedor/$1';

$route['admin/inventario/compras'] = 'admin/inventario/compras';
$route['admin/inventario/compras/add'] = 'admin/inventario/add_compra';
$route['admin/inventario/compras/store'] = 'admin/inventario/store_compra';
$route['admin/inventario/compras/view'] = 'admin/inventario/view_compra';
$route['admin/inventario/compras/anular/(:num)'] = 'admin/inventario/anular_compra/$1';

$route['admin/inventario/movimientos'] = 'admin/inventario/movimientos';
$route['admin/inventario/movimientos/add'] = 'admin/inventario/add_movimiento';
$route['admin/inventario/movimientos/store'] = 'admin/inventario/store_movimiento';

$route['admin/inventario/reportes'] = 'admin/inventario/reportes';
$route['admin/inventario/reportes/stock'] = 'admin/inventario/reporte_stock';
$route['admin/inventario/reportes/movimientos'] = 'admin/inventario/reporte_movimientos';


$route['mantenimiento/sedes'] = 'mantenimiento/sedes/index';  
$route['mantenimiento/sedes/create'] = 'mantenimiento/sedes/create';  
$route['mantenimiento/sedes/edit/(:any)'] = 'mantenimiento/sedes/edit/$1';  
$route['mantenimiento/sedes/delete/(:any)'] = 'mantenimiento/sedes/delete/$1';
$route['mantenimiento/sedes/update/(:num)'] = 'mantenimiento/sedes/update/$1';

$route['doctorpdf'] = 'DoctorPdf/index';
$route['doctorpdf/ver/(:any)'] = 'DoctorPdf/ver/$1';
$route['doctorpdf/descargar/(:any)'] = 'DoctorPdf/descargar/$1';

$route['mantenimiento/prueba'] = 'mantenimiento/prueba/index';
$route['mantenimiento/prueba/nuevo'] = 'mantenimiento/prueba/nuevo';

$route['enlaces'] = 'Enlaces/index';
