@extends('layouts.app')

@section('content')
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">{{ $tarea->titulo }}</h1>
        <div>
            <a href="{{ route('empresas.show', $tarea->empresa) }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Volver a la Empresa
            </a>
            @can('update', $tarea)
                <a href="{{ route('tareas.edit', $tarea) }}" class="btn btn-warning">
                    <i class="fas fa-edit"></i> Editar
                </a>
            @endcan
            @can('updateStatus', $tarea)
                @if($tarea->estado != 'finalizado')
                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#cambiarEstadoModal">
                        <i class="fas fa-exchange-alt"></i> Cambiar Estado
                    </button>
                @endif
            @endcan
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <!-- Información de la Tarea -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5>Información de la Tarea</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <strong>Empresa:</strong> {{ $tarea->empresa->razon_social }}<br>
                            <strong>RUC:</strong> {{ $tarea->empresa->ruc }}<br>
                            <strong>Operador:</strong> {{ $tarea->operador->nombre_completo }}<br>
                            <strong>Estado:</strong>
                            <span
                                class="badge badge-{{ $tarea->estado_color }}">{{ ucfirst(str_replace('_', ' ', $tarea->estado)) }}</span><br>
                            <strong>Prioridad:</strong>
                            <span
                                class="badge badge-{{ $tarea->prioridad_color }}">{{ ucfirst($tarea->prioridad) }}</span>
                        </div>
                        <div class="col-md-6">
                            <strong>Fecha Inicio Estimada:</strong>
                            {{ $tarea->fecha_inicio_estimada ? $tarea->fecha_inicio_estimada->format('d/m/Y') : 'N/A' }}<br>
                            <strong>Fecha Fin Estimada:</strong>
                            {{ $tarea->fecha_fin_estimada ? $tarea->fecha_fin_estimada->format('d/m/Y') : 'N/A' }}<br>
                            @if ($tarea->fecha_inicio_real)
                                <strong>Fecha Inicio Real:</strong> {{ $tarea->fecha_inicio_real->format('d/m/Y') }}<br>
                            @endif
                            @if ($tarea->fecha_fin_real)
                                <strong>Fecha Fin Real:</strong> {{ $tarea->fecha_fin_real->format('d/m/Y') }}<br>
                            @endif
                        </div>
                    </div>
                    <div class="mt-3">
                        <strong>Descripción:</strong><br>
                        {{ $tarea->descripcion }}
                    </div>

                    @if ($tarea->estado === 'finalizado' && $tarea->observaciones_finales)
                        <div class="mt-3">
                            <strong>Observaciones Finales (Solución):</strong><br>
                            <div class="alert alert-success">
                                {{ $tarea->observaciones_finales }}
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Comentarios -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5>Comentarios</h5>
                </div>
                <div class="card-body">
                    @foreach ($tarea->comentarios as $comentario)
                        <div class="border-bottom pb-3 mb-3">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <strong>{{ $comentario->user->nombre_completo }}</strong>
                                    <small class="text-muted">{{ $comentario->user->getRoleNames()->first() }}</small>
                                </div>
                                <small class="text-muted">{{ $comentario->created_at->diffForHumans() }}</small>
                            </div>
                            <p class="mt-2 mb-0">{{ $comentario->comentario }}</p>
                        </div>
                    @endforeach

                    @can('comment', $tarea)
                        <form method="POST" action="{{ route('tareas.comment', $tarea) }}">
                            @csrf
                            <div class="form-group mb-3">
                                <textarea class="form-control @error('comentario') is-invalid @enderror" name="comentario" rows="3"
                                    placeholder="Escribe tu comentario..." required></textarea>
                                @error('comentario')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <button type="submit" class="btn btn-primary">Añadir Comentario</button>
                        </form>
                    @endcan
                </div>
            </div>

            <!-- Historial de Actividad -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5><i class="fas fa-history me-2"></i> Historial de Cambios</h5>
                </div>
                <div class="card-body p-0">
                    <div class="list-group list-group-flush">
                        @forelse ($auditorias as $audit)
                            <div class="list-group-item">
                                <div class="d-flex justify-content-between align-items-center mb-1">
                                    <div>
                                        <strong>{{ $audit->user->nombre_completo ?? 'Sistema' }}</strong>
                                        <span class="badge badge-light border ml-2 text-dark">{{ ucfirst(str_replace('_', ' ', $audit->accion)) }}</span>
                                    </div>
                                    <small class="text-muted">{{ $audit->created_at->format('d/m/Y H:i') }}</small>
                                </div>
                                
                                <div class="small text-muted">
                                    @if($audit->datos_anteriores && $audit->datos_nuevos)
                                        @foreach($audit->datos_nuevos as $key => $newVal)
                                            @php 
                                                $oldVal = $audit->datos_anteriores[$key] ?? null;
                                                if($key == 'updated_at' || $key == 'created_at') continue;
                                                // Simple comparison might not work for arrays/objects, but for strings/ints it is fine.
                                                if($newVal == $oldVal) continue;
                                            @endphp
                                            <div class="mb-1">
                                                <strong>{{ ucfirst(str_replace('_', ' ', $key)) }}:</strong>
                                                <span class="text-danger"><del>{{ is_array($oldVal) ? json_encode($oldVal) : ($oldVal ?? 'N/A') }}</del></span>
                                                <i class="fas fa-arrow-right mx-1 text-muted"></i>
                                                <span class="text-success">{{ is_array($newVal) ? json_encode($newVal) : ($newVal ?? 'N/A') }}</span>
                                            </div>
                                        @endforeach
                                    @elseif($audit->datos_nuevos)
                                        @foreach($audit->datos_nuevos as $key => $val)
                                            @if($key != 'updated_at' && $key != 'created_at')
                                                <div>
                                                    <strong>{{ ucfirst($key) }}:</strong> {{ is_array($val) ? json_encode($val) : $val }}
                                                </div>
                                            @endif
                                        @endforeach
                                    @else
                                        <span class="text-muted">Cambio registrado sin detalles.</span>
                                    @endif
                                </div>
                            </div>
                        @empty
                            <div class="list-group-item text-center text-muted py-3">
                                No hay historial registrado para esta tarea.
                            </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <!-- Material de Apoyo -->
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5>Material de Apoyo</h5>
                    @can('uploadMaterial', $tarea)
                        <button type="button" class="btn btn-sm btn-primary" data-toggle="modal"
                            data-target="#subirMaterialModal">
                            <i class="fas fa-upload"></i> Subir
                        </button>
                    @endcan
                </div>
                <div class="card-body">
                    @foreach ($tarea->materiales as $material)
                        <div class="border-bottom pb-2 mb-2">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <strong>{{ $material->nombre_archivo }}</strong><br>
                                    <small class="text-muted">{{ $material->tamaño_formateado }}</small><br>
                                    <small class="text-muted">{{ $material->user->nombre_completo }}</small>
                                </div>
                                <div>
                                    <div class="btn-group" role="group">
                                        <a href="{{ asset('storage/' . $material->ruta_archivo) }}" target="_blank"
                                            class="btn btn-sm btn-outline-info" title="Ver">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('materiales.download', $material) }}"
                                            class="btn btn-sm btn-outline-primary" title="Descargar">
                                            <i class="fas fa-download"></i>
                                        </a>
                                        @can('delete', $material)
                                            <form action="{{ route('materiales.destroy', $material) }}" method="POST"
                                                class="d-inline"
                                                onsubmit="return confirm('¿Estás seguro de eliminar este material?');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-outline-danger" title="Eliminar">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        @endcan
                                    </div>
                                </div>
                            </div>
                            @if ($material->descripcion)
                                <p class="mt-2 mb-0 text-muted">{{ $material->descripcion }}</p>
                            @endif
                            <small class="text-muted">{{ $material->created_at->diffForHumans() }}</small>
                        </div>
                    @endforeach

                    @if ($tarea->materiales->count() === 0)
                        <p class="text-muted">No hay material de apoyo subido.</p>
                    @endif
                </div>
            </div>

            <!-- Evidencias -->
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5>Evidencias</h5>
                    @can('uploadEvidence', $tarea)
                        <button type="button" class="btn btn-sm btn-success" data-toggle="modal"
                            data-target="#subirEvidenciaModal">
                            <i class="fas fa-upload"></i> Subir
                        </button>
                    @endcan
                </div>
                <div class="card-body">
                    @foreach ($tarea->evidencias as $evidencia)
                        <div class="border-bottom pb-2 mb-2">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <strong>{{ $evidencia->nombre_archivo }}</strong><br>
                                    <small class="text-muted">{{ $evidencia->tamaño_formateado }}</small><br>
                                    <small class="text-muted">{{ $evidencia->user->nombre_completo }}</small>
                                </div>
                                <div>
                                    <div class="btn-group" role="group">
                                        {{-- Generar URL manualmente para asegurar compatibilidad --}}
                                        <a href="{{ asset('storage/' . $evidencia->ruta_archivo) }}" target="_blank"
                                            class="btn btn-sm btn-outline-info" title="Ver">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('tareas.download-evidence', $evidencia) }}"
                                            class="btn btn-sm btn-outline-primary" title="Descargar">
                                            <i class="fas fa-download"></i>
                                        </a>
                                        @can('delete', $evidencia)
                                            <form action="{{ route('evidencias.destroy', $evidencia) }}" method="POST"
                                                class="d-inline"
                                                onsubmit="return confirm('¿Estás seguro de eliminar esta evidencia?');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-outline-danger" title="Eliminar">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        @endcan
                                    </div>
                                </div>
                            </div>
                            @if ($evidencia->descripcion)
                                <p class="mt-2 mb-0 text-muted">{{ $evidencia->descripcion }}</p>
                            @endif
                            <small class="text-muted">{{ $evidencia->created_at->diffForHumans() }}</small>
                        </div>
                    @endforeach

                    @if ($tarea->evidencias->count() === 0)
                        <p class="text-muted">No hay evidencias subidas.</p>
                    @endif
                </div>
            </div>

            <!-- Información adicional -->
            <div class="card">
                <div class="card-header">
                    <h5>Información Adicional</h5>
                </div>
                <div class="card-body">
                    <strong>Orden en la empresa:</strong> {{ $tarea->orden }}<br>
                    <strong>Días restantes:</strong>
                    @if ($tarea->dias_restantes > 0)
                        <span class="text-success">{{ $tarea->dias_restantes }} días</span>
                    @elseif($tarea->dias_restantes === 0)
                        <span class="text-warning">Hoy es el último día</span>
                    @else
                        <span class="text-danger">{{ abs($tarea->dias_restantes) }} días de retraso</span>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Cambiar Estado -->
    @can('updateStatus', $tarea)
        <div class="modal fade" id="cambiarEstadoModal" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form method="POST" action="{{ route('tareas.update-status', $tarea) }}">
                        @csrf
                        @method('PATCH')
                        <div class="modal-header">
                            <h5 class="modal-title">Cambiar Estado de la Tarea</h5>
                            <button type="button" class="close" data-dismiss="modal">
                                <span>&times;</span>
                            </button>
                        </div>

                        <div class="modal-body">
                            <div class="form-group">
                                <label for="estado">Nuevo Estado</label>
                                <select class="form-control" name="estado" required>
                                    <option value="pendiente" {{ $tarea->estado === 'pendiente' ? 'selected' : '' }}>
                                        Pendiente
                                    </option>
                                    <option value="en_progreso" {{ $tarea->estado === 'en_progreso' ? 'selected' : '' }}>
                                        En Progreso
                                    </option>
                                    <option value="finalizado" {{ $tarea->estado === 'finalizado' ? 'selected' : '' }}>
                                        Finalizado
                                    </option>
                                </select>
                            </div>

                            <div class="form-group" id="observacionesContainer" style="display: {{ $tarea->estado === 'finalizado' ? 'block' : 'none' }};">
                                <label for="observaciones_finales">Observaciones Finales (Solución)</label>
                                <textarea class="form-control text-uppercase" name="observaciones_finales" id="observacionesFinales" rows="3" 
                                    placeholder="Describa los procesos o cambios realizados..."
                                    oninput="this.value = this.value.toUpperCase()">{{ $tarea->observaciones_finales }}</textarea>
                                <small class="text-muted">Esta información no podrá ser modificada una vez guardada.</small>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                            <button type="submit" class="btn btn-primary">Actualizar Estado</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endcan

    <!-- Modal Subir Evidencia -->
    @can('uploadEvidence', $tarea)
        <div class="modal fade" id="subirEvidenciaModal" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form method="POST" action="{{ route('tareas.upload-evidence', $tarea) }}"
                        enctype="multipart/form-data">
                        @csrf
                        <div class="modal-header">
                            <h5 class="modal-title">Subir Evidencia</h5>
                            <button type="button" class="close" data-dismiss="modal">
                                <span>&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group mb-3">
                                <label for="archivo">Archivo</label>
                                <input type="file" class="form-control" name="archivo"
                                    accept=".pdf,.jpg,.jpeg,.png,.doc,.docx,.xls,.xlsx" required>
                                <small class="text-muted">Máximo 10MB. Formatos: PDF, JPG, PNG, DOC, DOCX, XLS, XLSX</small>
                            </div>
                            <div class="form-group mb-3">
                                <label for="descripcion">Descripción (opcional)</label>
                                <textarea class="form-control" name="descripcion" rows="3"
                                    placeholder="Describe el contenido de la evidencia..."></textarea>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                            <button type="submit" class="btn btn-primary">Subir Evidencia</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endcan
    <!-- Modal Subir Material -->
    @can('uploadMaterial', $tarea)
        <div class="modal fade" id="subirMaterialModal" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form method="POST" action="{{ route('tareas.upload-material', $tarea) }}"
                        enctype="multipart/form-data">
                        @csrf
                        <div class="modal-header">
                            <h5 class="modal-title">Subir Material de Apoyo</h5>
                            <button type="button" class="close" data-dismiss="modal">
                                <span>&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group mb-3">
                                <label for="archivo">Archivo</label>
                                <input type="file" class="form-control" name="archivo" required>
                                <small class="text-muted">Máximo 10MB. Cualquier formato de documento o imagen.</small>
                            </div>
                            <div class="form-group mb-3">
                                <label for="descripcion">Descripción (opcional)</label>
                                <textarea class="form-control" name="descripcion" rows="3"
                                    placeholder="Describe el contenido del material..."></textarea>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                            <button type="submit" class="btn btn-primary">Subir Material</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endcan
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            $('select[name="estado"]').change(function() {
                var estado = $(this).val();
                var container = $('#observacionesContainer');
                var textarea = $('#observacionesFinales');
                
                if (estado === 'finalizado') {
                    container.slideDown();
                    textarea.prop('required', true);
                } else {
                    container.slideUp();
                    textarea.prop('required', false);
                }
            });
        });
    </script>
@endsection