<div class="modal-header">
    <h5 class="modal-title" id="showTareaModalLabel">{{ $tarea->titulo }}</h5>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
</div>

<div class="modal-body">
    <div class="row">
        <div class="col-md-12">
            <!-- Información de la Tarea -->
            <div class="card mb-3">
                <div class="card-header bg-light">
                    <h6 class="mb-0">Información General</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <strong>Empresa:</strong> {{ $tarea->empresa->razon_social }}<br>
                            <strong>RUC:</strong> {{ $tarea->empresa->ruc }}<br>
                            <strong>Operador:</strong> {{ $tarea->operador->nombre_completo }}<br>
                            <strong>Estado:</strong>
                            <span class="badge badge-{{ $tarea->estado_color }}">
                                {{ ucfirst(str_replace('_', ' ', $tarea->estado)) }}
                            </span><br>
                            <strong>Prioridad:</strong>
                            <span class="badge badge-{{ $tarea->prioridad_color }}">
                                {{ ucfirst($tarea->prioridad) }}
                            </span>
                        </div>
                        <div class="col-md-6">
                            <strong>Fecha Inicio Est.:</strong> {{ $tarea->fecha_inicio_estimada ? $tarea->fecha_inicio_estimada->format('d/m/Y') : 'N/A' }}<br>
                            <strong>Fecha Fin Est.:</strong> {{ $tarea->fecha_fin_estimada ? $tarea->fecha_fin_estimada->format('d/m/Y') : 'N/A' }}<br>
                            @if ($tarea->fecha_inicio_real)
                                <strong>Inicio Real:</strong> {{ $tarea->fecha_inicio_real->format('d/m/Y') }}<br>
                            @endif
                            @if ($tarea->fecha_fin_real)
                                <strong>Fin Real:</strong> {{ $tarea->fecha_fin_real->format('d/m/Y') }}<br>
                            @endif
                        </div>
                    </div>
                    <div class="mt-3">
                        <strong>Descripción:</strong>
                        <p class="text-muted border p-2 rounded bg-light">{{ $tarea->descripcion }}</p>
                    </div>

                    @if ($tarea->estado === 'finalizado' && $tarea->observaciones_finales)
                        <div class="mt-3">
                            <strong>Observaciones Finales (Solución):</strong>
                            <div class="alert alert-success">
                                {{ $tarea->observaciones_finales }}
                            </div>
                        </div>
                    @endif
                </div>
            </div>
            
            <!-- Chat / Comentarios -->
            <div class="card mt-3">
                <div class="card-header bg-light d-flex justify-content-between align-items-center">
                    <h6 class="mb-0">Chat / Comentarios</h6>
                    <span class="badge badge-secondary">{{ $tarea->comentarios->count() }}</span>
                </div>
                <div class="card-body">
                    <div id="chat-messages" style="max-height: 300px; overflow-y: auto;" class="mb-3">
                        @forelse($tarea->comentarios->sortBy('created_at') as $comentario)
                            <div class="media mb-3 {{ $comentario->user_id == auth()->id() ? 'flex-row-reverse' : '' }}">
                                <div class="media-body {{ $comentario->user_id == auth()->id() ? 'text-right' : '' }}">
                                    <h6 class="mt-0 mb-1 font-weight-bold">
                                        {{ $comentario->user->nombre_completo }}
                                        <small class="text-muted ml-2">{{ $comentario->created_at->format('d/m/Y H:i') }}</small>
                                    </h6>
                                    <div class="p-2 rounded {{ $comentario->user_id == auth()->id() ? 'bg-primary text-white' : 'bg-light text-dark shadow-sm' }}" 
                                         style="display: inline-block; max-width: 80%; text-align: left;">
                                        {{ $comentario->comentario }}
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div class="text-center text-muted py-3">
                                <small>No hay comentarios aún. ¡Inicia la conversación!</small>
                            </div>
                        @endforelse
                    </div>

                    <form id="addCommentForm" action="{{ route('tareas.comment', $tarea) }}" method="POST">
                        @csrf
                        <div class="input-group">
                            <input type="text" name="comentario" class="form-control" placeholder="Escribe un comentario..." required autocomplete="off">
                            <div class="input-group-append">
                                <button class="btn btn-primary" type="submit">
                                    <i class="fas fa-paper-plane"></i> Enviar
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
    <a href="{{ route('tareas.show', $tarea) }}" class="btn btn-primary" target="_blank">
        <i class="fas fa-external-link-alt"></i> Ver Detalle Completo
    </a>
</div>
