<div class="modal-header">
    <h5 class="modal-title" id="editTareaModalLabel">Editar Tarea: {{ $tarea->titulo }}</h5>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
</div>

<form id="editTareaForm" action="{{ route('tareas.update', $tarea) }}" method="POST">
    @csrf
    @method('PUT')
    
    <div class="modal-body">
        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <label for="titulo">Título de la Tarea</label>
                    <input type="text" class="form-control text-uppercase @error('titulo') is-invalid @enderror" 
                        id="titulo" name="titulo" value="{{ old('titulo', $tarea->titulo) }}" required 
                        oninput="this.value = this.value.toUpperCase()">
                    @error('titulo')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="operador_id">Operador Asignado</label>
                    <select class="form-control @error('operador_id') is-invalid @enderror" id="operador_id" name="operador_id" required>
                        <option value="">Seleccionar Operador</option>
                        @foreach ($operadores as $operador)
                            <option value="{{ $operador->id }}" {{ old('operador_id', $tarea->operador_id) == $operador->id ? 'selected' : '' }}>
                                {{ $operador->nombre_completo }}
                            </option>
                        @endforeach
                    </select>
                    @error('operador_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="col-md-6">
                <!-- Keep Priority and Status consistent with logic -->
                <div class="form-group">
                    <label for="prioridad">Prioridad</label>
                    <select class="form-control @error('prioridad') is-invalid @enderror" id="prioridad" name="prioridad" required>
                        @foreach ($prioridades as $value => $label)
                            <option value="{{ $value }}" {{ old('prioridad', $tarea->prioridad) == $value ? 'selected' : '' }}>
                                {{ $label }}
                            </option>
                        @endforeach
                    </select>
                    @error('prioridad')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
        </div>
        
        <!-- Status is usually managed via status updates, but allowing edit here -->
        <div class="row">
             <div class="col-md-6">
                <div class="form-group">
                    <label for="fecha_inicio_estimada">Fecha Inicio Estimada</label>
                    <input type="date" class="form-control @error('fecha_inicio_estimada') is-invalid @enderror" 
                        id="fecha_inicio_estimada" name="fecha_inicio_estimada" 
                        value="{{ old('fecha_inicio_estimada', $tarea->fecha_inicio_estimada ? $tarea->fecha_inicio_estimada->format('Y-m-d') : '') }}" required>
                    @error('fecha_inicio_estimada')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="fecha_fin_estimada">Fecha Fin Estimada</label>
                    <input type="date" class="form-control @error('fecha_fin_estimada') is-invalid @enderror" 
                        id="fecha_fin_estimada" name="fecha_fin_estimada" 
                        value="{{ old('fecha_fin_estimada', $tarea->fecha_fin_estimada ? $tarea->fecha_fin_estimada->format('Y-m-d') : '') }}" required>
                    @error('fecha_fin_estimada')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
        </div>

        <div class="form-group">
            <label for="descripcion">Descripción</label>
            <textarea class="form-control text-uppercase @error('descripcion') is-invalid @enderror" 
                id="descripcion" name="descripcion" rows="3" required 
                oninput="this.value = this.value.toUpperCase()">{{ old('descripcion', $tarea->descripcion) }}</textarea>
            @error('descripcion')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="modal-footer px-0 pb-0">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
            <button type="submit" class="btn btn-primary">Guardar Cambios</button>
        </div>
    </div>
</form>

<hr>

<div class="px-3 pb-3">
    <h6 class="font-weight-bold">Material de Apoyo</h6>
    
    <div id="materiales-list" class="mb-3">
        @forelse($tarea->materiales as $material)
            <div class="d-flex justify-content-between align-items-center mb-2 p-2 border rounded">
                <div>
                    <a href="{{ route('materiales.download', $material) }}" target="_blank">
                        <i class="fas fa-file-download"></i> {{ $material->nombre_archivo }}
                    </a>
                    <small class="d-block text-muted">{{ $material->created_at->format('d/m/Y H:i') }}</small>
                </div>
                <button type="button" class="btn btn-sm btn-danger btn-delete-material" data-url="{{ route('materiales.destroy', $material) }}">
                    <i class="fas fa-trash"></i>
                </button>
            </div>
        @empty
            <p class="text-muted small">No hay material adjunto.</p>
        @endforelse
    </div>

    <form id="uploadMaterialForm" action="{{ route('tareas.upload-material', $tarea) }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="input-group">
            <div class="custom-file">
                <input type="file" class="custom-file-input" id="archivoMaterial" name="archivo" required>
                <label class="custom-file-label" for="archivoMaterial">Elegir archivo...</label>
            </div>
            <div class="input-group-append">
                <button class="btn btn-outline-secondary" type="submit">Subir</button>
            </div>
        </div>
        <small class="text-muted">Formatos permitidos: Todo tipo de archivo. Max: 10MB</small>
    </form>
</div>
