<div class="card mb-2 kanban-card shadow-sm border-0" data-id="{{ $tarea->id }}">
    <div class="card-body p-3">
        <div class="d-flex justify-content-between mb-2">
            <span class="badge badge-{{ $tarea->prioridad_color }}">{{ ucfirst($tarea->prioridad) }}</span>
            @if($tarea->fecha_fin_estimada)
                <small class="{{ $tarea->fecha_fin_estimada < now()->startOfDay() && $tarea->estado != 'finalizado' ? 'text-danger font-weight-bold' : 'text-muted' }}">
                    <i class="far fa-calendar-alt"></i> {{ $tarea->fecha_fin_estimada->format('d/m') }}
                </small>
            @endif
        </div>
        <h6 class="card-title mb-1">
            <a href="{{ route('tareas.show', $tarea) }}" class="text-dark">
                {{ Str::limit($tarea->titulo, 50) }}
            </a>
        </h6>
        <div class="small text-muted mb-2 text-truncate" title="{{ $tarea->empresa->razon_social }}">
            <i class="fas fa-building me-1"></i> {{ $tarea->empresa->nombre_comercial ?? $tarea->empresa->razon_social }}
        </div>
        
        <div class="d-flex justify-content-between align-items-center mt-2 border-top pt-2">
            <div class="d-flex align-items-center" title="Operador: {{ $tarea->operador->nombre_completo }}">
                 <div class="rounded-circle bg-secondary text-white d-flex align-items-center justify-content-center" 
                      style="width: 24px; height: 24px; font-size: 10px;">
                      {{ substr($tarea->operador->nombre_corto ?? $tarea->operador->name, 0, 2) }}
                 </div>
                 <small class="ml-1 text-muted" style="font-size: 0.8rem;">{{ Str::limit($tarea->operador->nombre_corto, 10) }}</small>
            </div>
        </div>
    </div>
</div>
