@extends('layouts.app')

@section('content')
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Editar Tarea: {{ $tarea->titulo }}</h1>
    <a href="{{ route('tareas.show', $tarea->id) }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Volver
    </a>
</div>

<form method="POST" action="{{ route('tareas.update', $tarea->id) }}">
    @csrf
    @method('PATCH')
    
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h5>Información de la Tarea</h5>
                </div>
                <div class="card-body">
                    <div class="form-group mb-3">
                        <label for="titulo">Título de la Tarea</label>
                        <input type="text" class="form-control @error('titulo') is-invalid @enderror" 
                               id="titulo" name="titulo" value="{{ old('titulo', $tarea->titulo) }}" required>
                        @error('titulo')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group mb-3">
                        <label for="descripcion">Descripción</label>
                        <textarea class="form-control @error('descripcion') is-invalid @enderror" 
                                  id="descripcion" name="descripcion" rows="4" required>{{ old('descripcion', $tarea->descripcion) }}</textarea>
                        @error('descripcion')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label for="fecha_inicio_estimada">Fecha Inicio Estimada</label>
                                <input type="date" class="form-control @error('fecha_inicio_estimada') is-invalid @enderror" 
                                       id="fecha_inicio_estimada" name="fecha_inicio_estimada" 
                                       value="{{ old('fecha_inicio_estimada', $tarea->fecha_inicio_estimada ? $tarea->fecha_inicio_estimada->format('Y-m-d') : '') }}" required>
                                @error('fecha_inicio_estimada')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label for="fecha_fin_estimada">Fecha Fin Estimada</label>
                                <input type="date" class="form-control @error('fecha_fin_estimada') is-invalid @enderror" 
                                       id="fecha_fin_estimada" name="fecha_fin_estimada" 
                                       value="{{ old('fecha_fin_estimada', $tarea->fecha_fin_estimada ? $tarea->fecha_fin_estimada->format('Y-m-d') : '') }}" required>
                                @error('fecha_fin_estimada')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label for="prioridad">Prioridad</label>
                                <select class="form-control @error('prioridad') is-invalid @enderror" 
                                        id="prioridad" name="prioridad" required>
                                    @foreach($prioridades as $valor => $etiqueta)
                                        <option value="{{ $valor }}" {{ old('prioridad', $tarea->prioridad) === $valor ? 'selected' : '' }}>
                                            {{ $etiqueta }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('prioridad')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label for="operador_id">Operador Asignado</label>
                                <select class="form-control @error('operador_id') is-invalid @enderror" 
                                        id="operador_id" name="operador_id" required>
                                    <option value="">Seleccionar operador</option>
                                    @foreach($operadores as $operador)
                                        <option value="{{ $operador->id }}" {{ old('operador_id', $tarea->operador_id) == $operador->id ? 'selected' : '' }}>
                                            {{ $operador->nombre_completo }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('operador_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5>Información Actual</h5>
                </div>
                <div class="card-body">
                    <p><strong>Empresa:</strong> {{ $tarea->empresa->razon_social }}</p>
                    <p><strong>Estado Actual:</strong> 
                        <span class="badge badge-{{ $tarea->estado_color }}">
                            {{ ucfirst(str_replace('_', ' ', $tarea->estado)) }}
                        </span>
                    </p>
                    <p><strong>Prioridad Actual:</strong> 
                        <span class="badge badge-{{ $tarea->prioridad_color }}">
                            {{ ucfirst($tarea->prioridad) }}
                        </span>
                    </p>
                    <p><strong>Orden en Empresa:</strong> {{ $tarea->orden }}</p>
                    <p><strong>Creado:</strong> {{ $tarea->created_at->format('d/m/Y H:i') }}</p>
                    
                    @if($tarea->fecha_inicio_real)
                        <p><strong>Inicio Real:</strong> {{ $tarea->fecha_inicio_real->format('d/m/Y') }}</p>
                    @endif
                    
                    @if($tarea->fecha_fin_real)
                        <p><strong>Fin Real:</strong> {{ $tarea->fecha_fin_real->format('d/m/Y') }}</p>
                    @endif
                    
                    @if($tarea->estado === 'pendiente')
                        <div class="alert alert-info">
                            <small>Solo puedes editar tareas pendientes.</small>
                        </div>
                    @endif
                </div>
            </div>
            
            <!-- Progreso de evidencias y comentarios -->
            <div class="card mt-3">
                <div class="card-header">
                    <h5>Progreso</h5>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-6">
                            <h4 class="text-primary">{{ $tarea->evidencias->count() }}</h4>
                            <small class="text-muted">Evidencias</small>
                        </div>
                        <div class="col-6">
                            <h4 class="text-info">{{ $tarea->comentarios->count() }}</h4>
                            <small class="text-muted">Comentarios</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="mt-4">
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Actualizar Tarea
        </button>
        <a href="{{ route('tareas.show', $tarea->id) }}" class="btn btn-secondary">
            <i class="fas fa-times"></i> Cancelar
        </a>
    </div>
</form>
@endsection

@section('scripts')
<script>
// Validación de fechas en el cliente
document.getElementById('fecha_inicio_estimada').addEventListener('change', function() {
    const fechaInicio = new Date(this.value);
    const fechaFinInput = document.getElementById('fecha_fin_estimada');
    const fechaFin = new Date(fechaFinInput.value);
    
    if (fechaFin <= fechaInicio) {
        // Ajustar fecha fin para que sea al menos un día después
        const nuevaFechaFin = new Date(fechaInicio);
        nuevaFechaFin.setDate(nuevaFechaFin.getDate() + 1);
        fechaFinInput.value = nuevaFechaFin.toISOString().split('T')[0];
    }
});

document.getElementById('fecha_fin_estimada').addEventListener('change', function() {
    const fechaFin = new Date(this.value);
    const fechaInicioInput = document.getElementById('fecha_inicio_estimada');
    const fechaInicio = new Date(fechaInicioInput.value);
    
    if (fechaFin <= fechaInicio) {
        alert('La fecha de fin debe ser posterior a la fecha de inicio.');
        this.focus();
    }
});
</script>
@endsection
