<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Reporte Mensual de Tareas</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            color: #333;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #0056b3;
            padding-bottom: 10px;
        }
        .header h1 {
            color: #0056b3;
            margin: 0;
            font-size: 24px;
        }
        .header p {
            margin: 5px 0;
            color: #666;
        }
        .meta-info {
            margin-bottom: 20px;
        }
        .meta-info table {
            width: 100%;
        }
        .meta-info td {
            padding: 5px;
        }
        .summary-cards {
            margin-bottom: 20px;
            width: 100%;
        }
        .summary-card {
            background-color: #f8f9fa;
            border: 1px solid #ddd;
            padding: 10px;
            text-align: center;
            display: inline-block;
            width: 30%;
            margin-right: 2%;
        }
        table.tasks {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        table.tasks th, table.tasks td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        table.tasks th {
            background-color: #0056b3;
            color: white;
            font-weight: bold;
        }
        table.tasks tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        .status-badge {
            padding: 3px 8px;
            border-radius: 10px;
            color: white;
            font-size: 10px;
            text-transform: uppercase;
        }
        .status-pendiente { background-color: #ffc107; color: #000; }
        .status-en_progreso { background-color: #17a2b8; }
        .status-finalizado { background-color: #28a745; }
        .status-cancelado { background-color: #dc3545; }
        
        .footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            text-align: center;
            font-size: 10px;
            color: #999;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
        .page-break {
            page-break-after: always;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>REPORTE MENSUAL DE TAREAS</h1>
        <p>Generado por: {{ $proveedor }}</p>
    </div>

    <div class="meta-info">
        <table style="width: 100%">
            <tr>
                <td><strong>Periodo:</strong> {{ \Carbon\Carbon::create()->month($mes)->locale('es')->monthName }} {{ $anio }}</td>
                <td style="text-align: right"><strong>Fecha de Emisión:</strong> {{ $fecha_generacion }}</td>
            </tr>
        </table>
    </div>

    <div class="summary-cards">
        <table style="width: 100%">
            <tr>
                <td style="width: 33%; padding: 5px;">
                    <div style="background: #e3f2fd; border: 1px solid #90caf9; padding: 15px; text-align: center; border-radius: 5px;">
                        <div style="font-size: 24px; font-weight: bold; color: #1565c0;">{{ $total_tareas }}</div>
                        <div style="color: #1565c0;">Total Tareas</div>
                    </div>
                </td>
                <td style="width: 33%; padding: 5px;">
                    <div style="background: #e8f5e9; border: 1px solid #a5d6a7; padding: 15px; text-align: center; border-radius: 5px;">
                        <div style="font-size: 24px; font-weight: bold; color: #2e7d32;">{{ $tareas_completadas }}</div>
                        <div style="color: #2e7d32;">Completadas</div>
                    </div>
                </td>
                <td style="width: 33%; padding: 5px;">
                    <div style="background: #fff3e0; border: 1px solid #ffcc80; padding: 15px; text-align: center; border-radius: 5px;">
                        <div style="font-size: 24px; font-weight: bold; color: #ef6c00;">{{ $tareas_pendientes }}</div>
                        <div style="color: #ef6c00;">Pendientes</div>
                    </div>
                </td>
            </tr>
        </table>
    </div>

    <h3 style="margin-top: 20px; color: #333;">Detalle de Tareas</h3>
    
    @php
        $currentEmpresa = null;
    @endphp

    <table class="tasks">
        <thead>
            <tr>
                <th style="width: 25%">Empresa</th>
                <th style="width: 30%">Tarea</th>
                <th style="width: 15%">Operador</th>
                <th style="width: 10%">Estado</th>
                <th style="width: 10%">Inicio</th>
                <th style="width: 10%">Fin</th>
            </tr>
        </thead>
        <tbody>
            @foreach($tareas as $tarea)
                <tr>
                    <td>{{ $tarea->empresa->nombre_comercial ?? $tarea->empresa->razon_social }}</td>
                    <td>
                        <strong>{{ $tarea->titulo }}</strong><br>
                        <span style="font-size: 10px; color: #666;">{{ Str::limit($tarea->descripcion, 50) }}</span>
                    </td>
                    <td>{{ $tarea->operador->nombre_corto }}</td>
                    <td>
                        <span class="status-badge status-{{ $tarea->estado }}">
                            {{ ucfirst(str_replace('_', ' ', $tarea->estado)) }}
                        </span>
                    </td>
                    <td>{{ $tarea->fecha_inicio_estimada ? $tarea->fecha_inicio_estimada->format('d/m/Y') : '-' }}</td>
                    <td>{{ $tarea->fecha_fin_estimada ? $tarea->fecha_fin_estimada->format('d/m/Y') : '-' }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="footer">
        <p>Sistema de Gestión de Tareas - Reporte generado automáticamente</p>
    </div>

    <script type="text/php">
        if (isset($pdf)) {
            $text = "Página {PAGE_NUM} de {PAGE_COUNT}";
            $size = 9;
            $font = $fontMetrics->getFont("Arial");
            $width = $fontMetrics->getTextWidth($text, $font, $size);
            $pdf->page_text($pdf->get_width() - $width - 30, $pdf->get_height() - 30, $text, $font, $size, [0.5, 0.5, 0.5]);
        }
    </script>
</body>
</html>
