<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Actividad Mensual</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            color: #333;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #0056b3;
            padding-bottom: 10px;
        }
        .header h1 {
            color: #0056b3;
            margin: 0;
            font-size: 24px;
        }
        .header p {
            margin: 5px 0;
            color: #666;
        }
        .meta-info {
            margin-bottom: 20px;
        }
        .meta-info table {
            width: 100%;
        }
        .meta-info td {
            padding: 5px;
        }
        table.tasks {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        table.tasks th, table.tasks td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        table.tasks th {
            background-color: #0056b3;
            color: white;
            font-weight: bold;
        }
        table.tasks tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        .footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            text-align: center;
            font-size: 10px;
            color: #999;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
        .page-break {
            page-break-after: always;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>ACTIVIDAD MENSUAL</h1>
    </div>

    <div class="meta-info">
        <table style="width: 100%">
            <tr>
                <td><strong>Periodo:</strong> {{ \Carbon\Carbon::create()->month($mes)->locale('es')->monthName }} {{ $anio }}</td>
                <td style="text-align: right"><strong>Fecha de Emisión:</strong> {{ $fecha_generacion }}</td>
            </tr>
        </table>
    </div>

    <h3 style="margin-top: 20px; color: #333;">Detalle de Actividades</h3>
    
    <table class="tasks">
        <thead>
            <tr>
                <th style="width: 25%">Empresa</th>
                <th style="width: 15%">RUC</th>
                <th style="width: 45%">Problema</th>
                <th style="width: 15%">Fecha</th>
            </tr>
        </thead>
        <tbody>
            @foreach($tareas as $tarea)
                <tr>
                    <td>{{ $tarea->empresa->nombre_comercial ?? $tarea->empresa->razon_social }}</td>
                    <td>{{ $tarea->empresa->ruc }}</td>
                    <td>
                        <strong>{{ $tarea->titulo }}</strong><br>
                        <span style="font-size: 10px; color: #666;">{{ Str::limit($tarea->descripcion, 100) }}</span>
                    </td>
                    <td>{{ $tarea->fecha_fin_real ? $tarea->fecha_fin_real->format('d/m/Y') : '-' }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <!-- <div class="footer">
        <p>Sistema de Gestión de Tareas - Reporte generado automáticamente</p>
    </div> -->

    <script type="text/php">
        if (isset($pdf)) {
            $text = "Página {PAGE_NUM} de {PAGE_COUNT}";
            $size = 9;
            $font = $fontMetrics->getFont("Arial");
            $width = $fontMetrics->getTextWidth($text, $font, $size);
            $pdf->page_text($pdf->get_width() - $width - 30, $pdf->get_height() - 30, $text, $font, $size, [0.5, 0.5, 0.5]);
        }
    </script>
</body>
</html>