@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <h1 class="h2 border-bottom pb-2 mb-4">Generar Reporte Mensual</h1>
            
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="fas fa-file-alt mr-2"></i> Configuración del Reporte</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('reportes.exportar') }}" method="POST" target="_blank">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="mes">Mes</label>
                                    <select name="mes" id="mes" class="form-control" required>
                                        @foreach(range(1, 12) as $m)
                                            <option value="{{ $m }}" {{ date('n') == $m ? 'selected' : '' }}>
                                                {{ Carbon\Carbon::create()->month($m)->locale('es')->monthName }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="anio">Año</label>
                                    <select name="anio" id="anio" class="form-control" required>
                                        @foreach(range(2020, date('Y') + 1) as $year)
                                            <option value="{{ $year }}" {{ date('Y') == $year ? 'selected' : '' }}>
                                                {{ $year }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="form-group mt-3">
                            <label class="font-weight-bold">Filtrar por Modo de Pago:</label>
                            <div class="mb-2">
                                <div class="custom-control custom-checkbox custom-control-inline">
                                    <input type="checkbox" class="custom-control-input mode-filter" id="filter_mensual" value="mensual" checked>
                                    <label class="custom-control-label" for="filter_mensual">Mensual</label>
                                </div>
                                <div class="custom-control custom-checkbox custom-control-inline">
                                    <input type="checkbox" class="custom-control-input mode-filter" id="filter_anual" value="anual" checked>
                                    <label class="custom-control-label" for="filter_anual">Anual</label>
                                </div>
                                <div class="custom-control custom-checkbox custom-control-inline">
                                    <input type="checkbox" class="custom-control-input mode-filter" id="filter_gratuito" value="gratuito">
                                    <label class="custom-control-label" for="filter_gratuito">Gratuito</label>
                                </div>
                            </div>

                            <label class="font-weight-bold mt-2">Seleccionar Empresas:</label>
                            <div class="card">
                                <div class="card-body" style="max-height: 300px; overflow-y: auto;">
                                    <div class="custom-control custom-checkbox mb-2">
                                        <input type="checkbox" class="custom-control-input" id="selectAll">
                                        <label class="custom-control-label" for="selectAll"><strong>Seleccionar Todas</strong></label>
                                    </div>
                                    <hr>
                                    <div class="row">
                                        @foreach($empresas as $empresa)
                                            <div class="col-md-6">
                                                <div class="custom-control custom-checkbox mb-2">
                                                    <input type="checkbox" name="empresas[]" 
                                                        class="custom-control-input empresa-checkbox" 
                                                        id="empresa_{{ $empresa->id }}" 
                                                        value="{{ $empresa->id }}"
                                                        data-modo-pago="{{ $empresa->modo_pago }}"
                                                        {{ in_array($empresa->modo_pago, ['mensual', 'anual']) ? 'checked' : '' }}>
                                                    <label class="custom-control-label" for="empresa_{{ $empresa->id }}">
                                                        {{ $empresa->nombre_comercial ?? $empresa->razon_social }}
                                                        <small class="text-muted">({{ $empresa->ruc }})</small>
                                                        <span class="badge badge-light border ml-1" style="font-size: 0.7em;">{{ ucfirst($empresa->modo_pago ?? 'gratuito') }}</span>
                                                    </label>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                            @error('empresas')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>

                        <div class="form-group mt-4">
                            <label class="font-weight-bold">Formato de Exportación:</label>
                            <div class="btn-group btn-group-toggle w-100" data-toggle="buttons">
                                <label class="btn btn-outline-success active">
                                    <input type="radio" name="formato" value="excel" checked> 
                                    <i class="fas fa-file-excel fa-lg mr-2"></i> Excel (.xlsx)
                                </label>
                                <label class="btn btn-outline-danger">
                                    <input type="radio" name="formato" value="pdf"> 
                                    <i class="fas fa-file-pdf fa-lg mr-2"></i> PDF Profesional
                                </label>
                            </div>
                        </div>

                        <div class="mt-4 text-right">
                            <button type="submit" class="btn btn-primary btn-lg px-5">
                                <i class="fas fa-download mr-2"></i> Generar Reporte
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    document.getElementById('selectAll').addEventListener('change', function() {
        const checkboxes = document.querySelectorAll('.empresa-checkbox');
        checkboxes.forEach(cb => cb.checked = this.checked);
        
        // Uncheck filters if selectAll is used manually? No, leave them.
    });

    // Filter Logic
    const modeFilters = document.querySelectorAll('.mode-filter');
    modeFilters.forEach(filter => {
        filter.addEventListener('change', function() {
            const mode = this.value;
            const isChecked = this.checked;
            
            // Find all companies with this mode
            const companyCheckboxes = document.querySelectorAll(`.empresa-checkbox[data-modo-pago="${mode}"]`);
            companyCheckboxes.forEach(cb => {
                cb.checked = isChecked;
            });
            
            // Optional: Update 'Select All' state
            updateSelectAllState();
        });
    });

    function updateSelectAllState() {
        const all = document.querySelectorAll('.empresa-checkbox');
        const checked = document.querySelectorAll('.empresa-checkbox:checked');
        document.getElementById('selectAll').checked = all.length === checked.length;
    }
    
    // Initial check for select all state
    updateSelectAllState();
</script>
@endsection
