<table>
    <thead>
        <tr>
            <th colspan="6" style="font-size: 16px; font-weight: bold; text-align: center;">REPORTE MENSUAL DE TAREAS</th>
        </tr>
        <tr>
            <th colspan="6" style="text-align: center;">Periodo: {{ \Carbon\Carbon::create()->month($mes)->locale('es')->monthName }} {{ $anio }}</th>
        </tr>
        <tr>
            <th colspan="6" style="text-align: center;">Generado por: {{ $proveedor }}</th>
        </tr>
        <tr>
            <th colspan="6"></th>
        </tr>
        <tr>
            <th style="font-weight: bold; background-color: #cccccc;">Empresa</th>
            <th style="font-weight: bold; background-color: #cccccc;">Tarea</th>
            <th style="font-weight: bold; background-color: #cccccc;">Descripción</th>
            <th style="font-weight: bold; background-color: #cccccc;">Operador</th>
            <th style="font-weight: bold; background-color: #cccccc;">Estado</th>
            <th style="font-weight: bold; background-color: #cccccc;">Fecha Inicio</th>
            <th style="font-weight: bold; background-color: #cccccc;">Fecha Fin</th>
        </tr>
    </thead>
    <tbody>
        @foreach($tareas as $tarea)
            <tr>
                <td>{{ $tarea->empresa->nombre_comercial ?? $tarea->empresa->razon_social }}</td>
                <td>{{ $tarea->titulo }}</td>
                <td>{{ $tarea->descripcion }}</td>
                <td>{{ $tarea->operador->nombre_completo }}</td>
                <td>{{ ucfirst(str_replace('_', ' ', $tarea->estado)) }}</td>
                <td>{{ $tarea->fecha_inicio_estimada ? $tarea->fecha_inicio_estimada->format('d/m/Y') : '-' }}</td>
                <td>{{ $tarea->fecha_fin_estimada ? $tarea->fecha_fin_estimada->format('d/m/Y') : '-' }}</td>
            </tr>
        @endforeach
    </tbody>
</table>
