@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row mb-4">
        <div class="col-12">
            <a href="{{ route('publico.index') }}" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left"></i> Volver a Buscar
            </a>
        </div>
    </div>

    <div class="row">
        <!-- Información de la Empresa -->
        <div class="col-md-4 mb-4">
            <div class="card shadow border-0 h-100">
                <div class="card-header bg-primary text-white text-center py-3">
                    <h5 class="mb-0 font-weight-bold">Información de la Empresa</h5>
                </div>
                <div class="card-body">
                    <div class="text-center mb-4">
                        <div class="avatar-circle bg-light text-primary mx-auto mb-3" style="width: 80px; height: 80px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 2rem;">
                            <i class="fas fa-building"></i>
                        </div>
                        <h4 class="card-title text-primary font-weight-bold">{{ $empresa->razon_social }}</h4>
                        <p class="text-muted mb-0">{{ $empresa->nombre_comercial }}</p>
                    </div>
                    
                    <hr>

                    <div class="mb-3">
                        <small class="text-muted text-uppercase font-weight-bold">RUC</small>
                        <p class="h5">{{ $empresa->ruc }}</p>
                    </div>

                    <div class="mb-3">
                        <small class="text-muted text-uppercase font-weight-bold">Estado</small>
                        <div>
                            <span class="badge badge-{{ $empresa->estado == 'aprobada' ? 'success' : 'warning' }} px-3 py-2">
                                {{ ucfirst($empresa->estado) }}
                            </span>
                        </div>
                    </div>

                    <div class="mb-3">
                        <small class="text-muted text-uppercase font-weight-bold">Progreso General</small>
                        <div class="progress mt-1" style="height: 20px;">
                            <div class="progress-bar bg-success" role="progressbar" 
                                 style="width: {{ $empresa->porcentaje_progreso }}%" 
                                 aria-valuenow="{{ $empresa->porcentaje_progreso }}" 
                                 aria-valuemin="0" 
                                 aria-valuemax="100">
                                {{ $empresa->porcentaje_progreso }}%
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Listado de Tareas -->
        <div class="col-md-8">
            <div class="card shadow border-0">
                <div class="card-header bg-white py-3">
                    <h5 class="mb-0 text-primary font-weight-bold">
                        <i class="fas fa-tasks mr-2"></i> Avance de Tareas
                    </h5>
                </div>
                <div class="card-body p-0">
                    @if($empresa->tareas->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="thead-light">
                                    <tr>
                                        <th>Tarea</th>
                                        <th class="text-center">Estado</th>
                                        <th class="text-center">Fecha Inicio</th>
                                        <th class="text-center">Fecha Fin</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($empresa->tareas as $tarea)
                                        <tr>
                                            <td>
                                                <div class="font-weight-bold">{{ $tarea->titulo }}</div>
                                                <small class="text-muted">{{ Str::limit($tarea->descripcion, 60) }}</small>
                                            </td>
                                            <td class="text-center align-middle">
                                                @php
                                                    $badges = [
                                                        'pendiente' => 'warning',
                                                        'en_progreso' => 'info',
                                                        'finalizado' => 'success',
                                                        'cancelado' => 'danger'
                                                    ];
                                                    $icons = [
                                                        'pendiente' => 'clock',
                                                        'en_progreso' => 'spinner fa-spin',
                                                        'finalizado' => 'check-circle',
                                                        'cancelado' => 'times-circle'
                                                    ];
                                                @endphp
                                                <span class="badge badge-{{ $badges[$tarea->estado] ?? 'secondary' }} px-3 py-2">
                                                    <i class="fas fa-{{ $icons[$tarea->estado] ?? 'circle' }} mr-1"></i>
                                                    {{ ucfirst(str_replace('_', ' ', $tarea->estado)) }}
                                                </span>
                                            </td>
                                            <td class="text-center align-middle">
                                                {{ $tarea->fecha_inicio_estimada ? $tarea->fecha_inicio_estimada->format('d/m/Y') : '-' }}
                                            </td>
                                            <td class="text-center align-middle">
                                                {{ $tarea->fecha_fin_estimada ? $tarea->fecha_fin_estimada->format('d/m/Y') : '-' }}
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-5 text-muted">
                            <i class="fas fa-clipboard-list fa-3x mb-3"></i>
                            <p>No hay tareas registradas para esta empresa.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
