@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="text-center mb-5">
                <h1 class="display-4 text-primary">Consulta de Avance</h1>
                <p class="lead text-muted">Ingresa el RUC de tu empresa para ver el estado de tus tareas.</p>
            </div>

            <div class="card shadow-lg border-0">
                <div class="card-body p-5">
                    <form action="{{ route('publico.buscar') }}" method="POST">
                        @csrf
                        <div class="form-group text-center">
                            <label for="ruc" class="font-weight-bold h5 mb-3">Número de RUC</label>
                            <input type="text" 
                                   class="form-control form-control-lg text-center @error('ruc') is-invalid @enderror" 
                                   id="ruc" 
                                   name="ruc" 
                                   placeholder="Ingrese los 11 dígitos" 
                                   maxlength="11" 
                                   required 
                                   autofocus>
                            
                            @error('ruc')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="text-center mt-4">
                            <button type="submit" class="btn btn-primary btn-lg px-5 rounded-pill shadow">
                                <i class="fas fa-search mr-2"></i> Consultar
                            </button>
                        </div>
                    </form>

                    @if(session('error'))
                        <div class="alert alert-danger mt-4 text-center">
                            <i class="fas fa-exclamation-circle mr-2"></i> {{ session('error') }}
                        </div>
                    @endif
                </div>
            </div>

            <div class="text-center mt-4">
                <a href="{{ route('login') }}" class="text-muted">
                    <small>¿Eres operador o proveedor? Inicia sesión aquí</small>
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
