@extends('layouts.app')

@section('content')
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Dashboard Proveedor</h1>
        <div class="btn-toolbar mb-2 mb-md-0">
            <div class="btn-group me-2">
                <a href="{{ route('empresas.create') }}" class="btn btn-sm btn-outline-primary">
                    <i class="fas fa-plus"></i> Nueva Empresa
                </a>
            </div>
        </div>
    </div>

    <!-- Estadísticas -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card text-white bg-primary">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4 class="card-title">{{ $stats['empresas_creadas'] }}</h4>
                            <p class="card-text">Empresas Creadas</p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-building fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card text-white bg-success">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4 class="card-title">{{ $stats['empresas_aprobadas'] }}</h4>
                            <p class="card-text">Empresas Aprobadas</p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-check-circle fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card text-white bg-warning">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4 class="card-title">{{ $stats['empresas_pendientes'] }}</h4>
                            <p class="card-text">Empresas Pendientes</p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-clock fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card text-white bg-info">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4 class="card-title">{{ $stats['porcentaje_exito'] }}%</h4>
                            <p class="card-text">Tasa de Éxito</p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-chart-line fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Segunda fila de estadísticas -->
    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card">
                <div class="card-body text-center">
                    <h2 class="text-primary">{{ $stats['tareas_total'] }}</h2>
                    <p class="text-muted">Tareas Total</p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body text-center">
                    <h2 class="text-success">{{ $stats['tareas_finalizadas'] }}</h2>
                    <p class="text-muted">Tareas Finalizadas</p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body text-center">
                    <h2 class="text-warning">{{ $stats['tareas_en_progreso'] }}</h2>
                    <p class="text-muted">Tareas en Progreso</p>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Empresas Recientes -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5>Mis Empresas Recientes</h5>
                    <a href="{{ route('empresas.index') }}" class="btn btn-sm btn-outline-primary">Ver todas</a>
                </div>
                <div class="card-body">
                    @if ($empresasRecientes->count() > 0)
                        @foreach ($empresasRecientes as $empresa)
                            <div class="border-bottom pb-2 mb-2">
                                <div class="d-flex justify-content-between align-items-start">
                                    <div>
                                        <h6>
                                            <a href="{{ route('empresas.show', $empresa) }}">{{ $empresa->nombre_comercial ?? $empresa->razon_social }}</a>
                                        </h6>
                                        <small class="text-muted">
                                            {{ $empresa->tareas->count() }} tareas
                                            | {{ $empresa->created_at->diffForHumans() }}
                                        </small>
                                    </div>
                                    <div>
                                        @if ($empresa->estado == 'aprobada')
                                            @php
                                                $tareasPendientes = $empresa->tareas->where('estado', '!=', 'finalizado')->count();
                                            @endphp
                                            @if ($tareasPendientes > 0)
                                                <span class="badge badge-danger">{{ $tareasPendientes }} Pendientes</span>
                                            @else
                                                <span class="badge badge-success">{{ ucfirst($empresa->estado) }}</span>
                                            @endif
                                        @else
                                            <span
                                                class="badge badge-{{ $empresa->estado === 'pendiente' ? 'warning' : 'danger' }}">
                                                {{ ucfirst($empresa->estado) }}
                                            </span>
                                        @endif
                                    </div>
                                </div>

                                @if ($empresa->tareas->count() > 0)
                                    <div class="mt-2">
                                        <small class="text-muted">Progreso:</small>
                                        <div class="progress" style="height: 5px;">
                                            <div class="progress-bar" role="progressbar"
                                                style="width: {{ $empresa->porcentaje_progreso }}%"
                                                aria-valuenow="{{ $empresa->porcentaje_progreso }}" aria-valuemin="0"
                                                aria-valuemax="100">
                                            </div>
                                        </div>
                                        <small class="text-muted">{{ $empresa->porcentaje_progreso }}%</small>
                                    </div>
                                @endif
                            </div>
                        @endforeach
                    @else
                        <p class="text-muted">No has creado empresas aún.</p>
                        <a href="{{ route('empresas.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Crear Primera Empresa
                        </a>
                    @endif
                </div>
            </div>
        </div>

        <!-- Tareas Activas -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5>Tareas Activas</h5>
                    <a href="{{ route('tareas.index') }}" class="btn btn-sm btn-outline-primary">Ver todas</a>
                </div>
                <div class="card-body" style="max-height: 400px; overflow-y: auto;">
                    @if ($tareasActivas->count() > 0)
                        @foreach ($tareasActivas as $tarea)
                            <div class="border-bottom pb-2 mb-2">
                                <div class="d-flex justify-content-between align-items-start">
                                    <div class="flex-grow-1">
                                        <h6 class="mb-1">
                                            <a href="{{ route('tareas.show', $tarea) }}">
                                                {{ Str::limit($tarea->titulo, 30) }}
                                            </a>
                                        </h6>
                                        <small class="text-muted">
                                            <strong>Operador:</strong> {{ $tarea->operador->nombre_completo }}<br>
                                            <strong>Fecha límite:</strong>
                                            <span
                                                class="{{ $tarea->fecha_fin_estimada->isPast() ? 'text-danger' : 'text-muted' }}">
                                                {{ $tarea->fecha_fin_estimada->format('d/m/Y') }}
                                            </span>
                                        </small>
                                    </div>
                                    <div class="text-right">
                                        <span class="badge badge-{{ $tarea->estado_color }}">
                                            {{ ucfirst($tarea->estado) }}
                                        </span><br>
                                        <span class="badge badge-{{ $tarea->prioridad_color }} mt-1">
                                            {{ ucfirst($tarea->prioridad) }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @else
                        <p class="text-muted">No tienes tareas activas.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>

    @if ($tareasRetrasadas->count() > 0)
        <!-- Tareas Retrasadas -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card border-danger">
                    <div class="card-header bg-danger text-white">
                        <h5 class="mb-0">
                            <i class="fas fa-exclamation-triangle"></i>
                            Tareas Retrasadas ({{ $tareasRetrasadas->count() }})
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            @foreach ($tareasRetrasadas as $tarea)
                                <div class="col-md-6 mb-3">
                                    <div class="card border-warning">
                                        <div class="card-body">
                                            <h6 class="card-title">
                                                <a href="{{ route('tareas.show', $tarea) }}">
                                                    {{ $tarea->titulo }}
                                                </a>
                                            </h6>
                                            <p class="card-text">
                                                <small class="text-muted">
                                                    <strong>Empresa:</strong> {{ $tarea->empresa->razon_social }}<br>
                                                    <strong>Operador:</strong>
                                                    {{ $tarea->operador->nombre_completo }}<br>
                                                    <strong>Retrasado por:</strong>
                                                    <span class="text-danger">
                                                        {{ abs($tarea->dias_restantes) }} días
                                                    </span>
                                                </small>
                                            </p>
                                            <div class="d-flex justify-content-between">
                                                <span class="badge badge-{{ $tarea->estado_color }}">
                                                    {{ ucfirst($tarea->estado) }}
                                                </span>
                                                <span class="badge badge-{{ $tarea->prioridad_color }}">
                                                    {{ ucfirst($tarea->prioridad) }}
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- Acciones Rápidas -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5>Acciones Rápidas</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3 mb-2">
                            <a href="{{ route('empresas.create') }}" class="btn btn-outline-primary btn-block">
                                <i class="fas fa-plus"></i> Nueva Empresa
                            </a>
                        </div>
                        <div class="col-md-3 mb-2">
                            <a href="{{ route('empresas.index') }}" class="btn btn-outline-info btn-block">
                                <i class="fas fa-list"></i> Mis Empresas
                            </a>
                        </div>
                        <div class="col-md-3 mb-2">
                            <a href="{{ route('tareas.index') }}" class="btn btn-outline-success btn-block">
                                <i class="fas fa-tasks"></i> Mis Tareas
                            </a>
                        </div>
                        <div class="col-md-3 mb-2">
                            <a href="{{ route('notificaciones.index') }}" class="btn btn-outline-warning btn-block">
                                <i class="fas fa-bell"></i> Notificaciones
                            </a>
                        </div>
                    </div>

                    <!-- Empresas con posibilidad de agregar tareas -->
                    @if ($empresasRecientes->where('estado', 'aprobada')->count() > 0)
                        <hr>
                        <h6>Empresas donde puedes agregar tareas:</h6>
                        <div class="row">
                            @foreach ($empresasRecientes->where('estado', 'aprobada') as $empresa)
                                <div class="col-md-6 mb-2">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span>{{ Str::limit($empresa->razon_social, 25) }}</span>
                                        <a href="{{ route('empresas.add-tareas', $empresa) }}"
                                            class="btn btn-sm btn-success">
                                            <i class="fas fa-plus"></i> Agregar
                                        </a>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif

                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        // Actualizar dashboard cada 30 segundos
        setInterval(function() {
            // Actualizar contador de notificaciones
            fetch('{{ route("notificaciones.count") }}')
                .then(response => response.json())
                .then(data => {
                    const badge = document.querySelector('#notification-count');
                    if (badge) {
                        if (data.count > 0) {
                            badge.textContent = data.count;
                            badge.classList.remove('d-none');
                        } else {
                            badge.classList.add('d-none');
                        }
                    }
                });
        }, 30000);
    </script>
@endsection
