@extends('layouts.app')

@section('content')
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Dashboard Operador</h1>
    </div>

    <!-- Estadísticas -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card text-white bg-primary">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4 class="card-title">{{ $stats['tareas_asignadas'] }}</h4>
                            <p class="card-text">Tareas Asignadas</p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-tasks fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card text-white bg-warning">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4 class="card-title">{{ $stats['tareas_pendientes'] }}</h4>
                            <p class="card-text">Pendientes</p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-clock fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card text-white bg-info">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4 class="card-title">{{ $stats['tareas_en_progreso'] }}</h4>
                            <p class="card-text">En Progreso</p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-spinner fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card text-white bg-success">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4 class="card-title">{{ $stats['tareas_finalizadas'] }}</h4>
                            <p class="card-text">Finalizadas</p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-check fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Tareas Pendientes -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5>Tareas Pendientes</h5>
                </div>
                <div class="card-body">
                    @if ($tareasPendientes->count() > 0)
                        @foreach ($tareasPendientes as $tarea)
                            <div class="border-bottom pb-2 mb-2">
                                <h6>
                                    <a href="{{ route('tareas.show', $tarea) }}">
                                        {{ $tarea->titulo }}
                                    </a>
                                </h6>
                                <small class="text-muted">
                                    <strong>Empresa:</strong> {{ $tarea->empresa->razon_social }}<br>
                                    <strong>Prioridad:</strong>
                                    <span class="badge badge-{{ $tarea->prioridad_color }}">
                                        {{ ucfirst($tarea->prioridad) }}
                                    </span>
                                </small>
                            </div>
                        @endforeach
                        <a href="{{ route('tareas.index') }}" class="btn btn-sm btn-primary">Ver todas</a>
                    @else
                        <p class="text-muted">No tienes tareas pendientes.</p>
                    @endif
                </div>
            </div>
        </div>

        <!-- Tareas en Progreso -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5>Tareas en Progreso</h5>
                </div>
                <div class="card-body">
                    @if ($tareasEnProgreso->count() > 0)
                        @foreach ($tareasEnProgreso as $tarea)
                            <div class="border-bottom pb-2 mb-2">
                                <h6>
                                    <a href="{{ route('tareas.show', $tarea) }}">
                                        {{ $tarea->titulo }}
                                    </a>
                                </h6>
                                <small class="text-muted">
                                    <strong>Empresa:</strong> {{ $tarea->empresa->razon_social }}<br>
                                    <strong>Fecha límite:</strong> {{ $tarea->fecha_fin_estimada->format('d/m/Y') }}
                                </small>
                            </div>
                        @endforeach
                        <a href="{{ route('tareas.index') }}" class="btn btn-sm btn-primary">Ver todas</a>
                    @else
                        <p class="text-muted">No tienes tareas en progreso.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>

    @if ($tareasUrgentes->count() > 0)
        <!-- Tareas Urgentes -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card border-danger">
                    <div class="card-header bg-danger text-white">
                        <h5 class="mb-0">
                            <i class="fas fa-exclamation-triangle"></i>
                            Tareas Urgentes
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            @foreach ($tareasUrgentes as $tarea)
                                <div class="col-md-4 mb-3">
                                    <div class="card border-warning">
                                        <div class="card-body">
                                            <h6 class="card-title">
                                                <a href="{{ route('tareas.show', $tarea) }}">
                                                    {{ $tarea->titulo }}
                                                </a>
                                            </h6>
                                            <p class="card-text">
                                                <small class="text-muted">
                                                    <strong>Empresa:</strong> {{ $tarea->empresa->razon_social }}<br>
                                                    <strong>Fecha límite:</strong>
                                                    {{ $tarea->fecha_fin_estimada->format('d/m/Y') }}
                                                </small>
                                            </p>
                                            <span class="badge badge-{{ $tarea->estado_color }}">
                                                {{ ucfirst($tarea->estado) }}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
@endsection
