<!-- resources/views/notificaciones/show.blade.php -->
@extends('layouts.app')

@section('content')
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Detalle de Notificación</h1>
        <a href="{{ route('notificaciones.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Volver
        </a>
    </div>

    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">{{ $notificacion->titulo }}</h5>
                    <div>
                        <span class="badge badge-{{ $notificacion->tipo === 'error' ? 'danger' : $notificacion->tipo }}">
                            {{ ucfirst($notificacion->tipo) }}
                        </span>
                        @if (!$notificacion->leida)
                            <span class="badge badge-primary">Nueva</span>
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    <p class="card-text">{{ $notificacion->mensaje }}</p>

                    <hr>

                    <div class="row">
                        <div class="col-md-6">
                            <small class="text-muted">
                                <i class="fas fa-clock"></i> <strong>Recibida:</strong>
                                {{ $notificacion->created_at->format('d/m/Y H:i:s') }}
                                <br>
                                <small>({{ $notificacion->created_at->diffForHumans() }})</small>
                            </small>
                        </div>
                        <div class="col-md-6">
                            @if ($notificacion->leida)
                                <small class="text-muted">
                                    <i class="fas fa-check"></i> <strong>Leída:</strong>
                                    {{ $notificacion->fecha_lectura->format('d/m/Y H:i:s') }}
                                    <br>
                                    <small>({{ $notificacion->fecha_lectura->diffForHumans() }})</small>
                                </small>
                            @else
                                <small class="text-warning">
                                    <i class="fas fa-exclamation-circle"></i> <strong>No leída</strong>
                                </small>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <div class="btn-group">
                        @can('markAsRead', $notificacion)
                            @if (!$notificacion->leida)
                                <button type="button" class="btn btn-success" onclick="markAsRead({{ $notificacion->id }})">
                                    <i class="fas fa-check"></i> Marcar como leída
                                </button>
                            @endif
                        @endcan

                        @can('delete', $notificacion)
                            <form method="POST" action="{{ route('notificaciones.destroy', $notificacion) }}"
                                class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger"
                                    onclick="return confirm('¿Eliminar esta notificación?')">
                                    <i class="fas fa-trash"></i> Eliminar
                                </button>
                            </form>
                        @endcan
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        function markAsRead(notificationId) {
            fetch(`/notificaciones/${notificationId}/read`, {
                    method: 'PATCH',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                        'Content-Type': 'application/json',
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Error al marcar como leída');
                });
        }
    </script>
@endsection
