<!-- resources/views/notificaciones/index.blade.php -->
@extends('layouts.app')

@section('content')
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Mis Notificaciones</h1>

        <div class="btn-group">
            @can('create', App\Models\Notificacion::class)
                <a href="{{ route('notificaciones.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Nueva Notificación
                </a>
            @endcan

            @can('markAllAsRead', App\Models\Notificacion::class)
                <button type="button" class="btn btn-secondary" onclick="markAllAsRead()">
                    <i class="fas fa-check-double"></i> Marcar todas como leídas
                </button>
            @endcan

            @can('clearAll', App\Models\Notificacion::class)
                <form method="POST" action="{{ route('notificaciones.clear-all') }}" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger"
                        onclick="return confirm('¿Eliminar todas las notificaciones?')">
                        <i class="fas fa-trash"></i> Limpiar todas
                    </button>
                </form>
            @endcan
        </div>
    </div>

    <!-- Resumen de notificaciones -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card text-white bg-primary">
                <div class="card-body text-center">
                    <h3>{{ $notificaciones->total() }}</h3>
                    <p class="mb-0">Total</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-warning">
                <div class="card-body text-center">
                    <h3>{{ $notificaciones->where('leida', false)->count() }}</h3>
                    <p class="mb-0">No leídas</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-success">
                <div class="card-body text-center">
                    <h3>{{ $notificaciones->where('leida', true)->count() }}</h3>
                    <p class="mb-0">Leídas</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-info">
                <div class="card-body text-center">
                    <h3>{{ $notificaciones->where('created_at', '>=', now()->subDay())->count() }}</h3>
                    <p class="mb-0">Hoy</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Lista de notificaciones -->
    <div class="row">
        <div class="col-md-12">
            @if ($notificaciones->count() > 0)
                @foreach ($notificaciones as $notificacion)
                    <div class="card mb-3 {{ $notificacion->leida ? '' : 'border-primary' }}">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start">
                                <div class="flex-grow-1">
                                    <div class="d-flex align-items-center mb-2">
                                        <h5 class="card-title mb-0">
                                            {{ $notificacion->titulo }}
                                            @if (!$notificacion->leida)
                                                <span class="badge badge-primary ml-2">Nueva</span>
                                            @endif
                                        </h5>
                                        <span
                                            class="badge badge-{{ $notificacion->tipo === 'error' ? 'danger' : $notificacion->tipo }} ml-auto">
                                            {{ ucfirst($notificacion->tipo) }}
                                        </span>
                                    </div>

                                    <p class="card-text">{{ $notificacion->mensaje }}</p>

                                    <div class="d-flex justify-content-between align-items-center">
                                        <small class="text-muted">
                                            <i class="fas fa-clock"></i> {{ $notificacion->created_at->diffForHumans() }}
                                            @if ($notificacion->leida)
                                                | <i class="fas fa-check"></i> Leída
                                                {{ $notificacion->fecha_lectura->diffForHumans() }}
                                            @endif
                                        </small>
                                    </div>
                                </div>

                                <div class="btn-group btn-group-sm ml-3">
                                    @can('view', $notificacion)
                                        <a href="{{ route('notificaciones.show', $notificacion) }}"
                                            class="btn btn-outline-primary">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    @endcan

                                    @can('markAsRead', $notificacion)
                                        @if (!$notificacion->leida)
                                            <button type="button" class="btn btn-outline-success"
                                                onclick="markAsRead({{ $notificacion->id }})">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        @endif
                                    @endcan

                                    @can('delete', $notificacion)
                                        <form method="POST" action="{{ route('notificaciones.destroy', $notificacion) }}"
                                            class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-outline-danger"
                                                onclick="return confirm('¿Eliminar esta notificación?')">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    @endcan
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach

                <!-- Paginación -->
                <div class="d-flex justify-content-center">
                    {{ $notificaciones->links() }}
                </div>
            @else
                <div class="col-12">
                    <div class="alert alert-info text-center">
                        <i class="fas fa-bell-slash fa-3x mb-3"></i>
                        <h4>No tienes notificaciones</h4>
                        <p class="mb-0">Cuando tengas notificaciones aparecerán aquí.</p>
                    </div>
                </div>
            @endif
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        function markAsRead(notificationId) {
            fetch(`/notificaciones/${notificationId}/read`, {
                    method: 'PATCH',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                        'Content-Type': 'application/json',
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Error al marcar como leída');
                });
        }

        function markAllAsRead() {
            fetch('{{ route("notificaciones.mark-all-read") }}', {
                    method: 'PATCH',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                        'Content-Type': 'application/json',
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Error al marcar todas como leídas');
                });
        }
    </script>
@endsection
