<!-- resources/views/notificaciones/create.blade.php -->
@extends('layouts.app')

@section('content')
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Enviar Notificación</h1>
        <a href="{{ route('notificaciones.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Volver
        </a>
    </div>

    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h5>Nueva Notificación</h5>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('notificaciones.store') }}">
                        @csrf

                        <div class="form-group">
                            <label for="titulo">Título</label>
                            <input type="text" class="form-control @error('titulo') is-invalid @enderror" id="titulo"
                                name="titulo" value="{{ old('titulo') }}" required maxlength="255">
                            @error('titulo')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="mensaje">Mensaje</label>
                            <textarea class="form-control @error('mensaje') is-invalid @enderror" id="mensaje" name="mensaje" rows="4"
                                required>{{ old('mensaje') }}</textarea>
                            @error('mensaje')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="tipo">Tipo</label>
                            <select class="form-control @error('tipo') is-invalid @enderror" id="tipo" name="tipo"
                                required>
                                <option value="">Seleccionar tipo</option>
                                <option value="info" {{ old('tipo') === 'info' ? 'selected' : '' }}>Información</option>
                                <option value="success" {{ old('tipo') === 'success' ? 'selected' : '' }}>Éxito</option>
                                <option value="warning" {{ old('tipo') === 'warning' ? 'selected' : '' }}>Advertencia
                                </option>
                                <option value="error" {{ old('tipo') === 'error' ? 'selected' : '' }}>Error</option>
                            </select>
                            @error('tipo')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="users">Destinatarios</label>
                            <select class="form-control @error('users') is-invalid @enderror" id="users" name="users[]"
                                multiple required>
                                @foreach ($usuarios as $usuario)
                                    <option value="{{ $usuario->id }}"
                                        {{ in_array($usuario->id, old('users', [])) ? 'selected' : '' }}>
                                        {{ $usuario->nombre_completo }} ({{ $usuario->getRoleNames()->first() }})
                                    </option>
                                @endforeach
                            </select>
                            <small class="text-muted">Mantén presionado Ctrl (Cmd en Mac) para seleccionar múltiples
                                usuarios</small>
                            @error('users')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group mb-0">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-paper-plane"></i> Enviar Notificación
                            </button>
                            <a href="{{ route('notificaciones.index') }}" class="btn btn-secondary">Cancelar</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        // Mejorar el selector múltiple
        document.addEventListener('DOMContentLoaded', function() {
            const selectElement = document.getElementById('users');

            // Agregar botones para seleccionar por rol
            const selectContainer = selectElement.parentNode;
            const buttonsDiv = document.createElement('div');
            buttonsDiv.className = 'mt-2 mb-3';
            buttonsDiv.innerHTML = `
        <small class="text-muted d-block mb-2">Selección rápida por rol:</small>
        <button type="button" class="btn btn-sm btn-outline-primary" onclick="selectByRole('administrador')">Administradores</button>
        <button type="button" class="btn btn-sm btn-outline-success" onclick="selectByRole('proveedor')">Proveedores</button>
        <button type="button" class="btn btn-sm btn-outline-info" onclick="selectByRole('operador')">Operadores</button>
        <button type="button" class="btn btn-sm btn-outline-secondary" onclick="selectAll()">Todos</button>
        <button type="button" class="btn btn-sm btn-outline-danger" onclick="clearSelection()">Limpiar</button>
    `;
            selectContainer.insertBefore(buttonsDiv, selectElement.nextSibling);
        });

        function selectByRole(role) {
            const selectElement = document.getElementById('users');
            const options = selectElement.options;

            // Limpiar selección
            for (let i = 0; i < options.length; i++) {
                options[i].selected = false;
            }

            // Seleccionar por rol
            for (let i = 0; i < options.length; i++) {
                if (options[i].text.includes(`(${role})`)) {
                    options[i].selected = true;
                }
            }
        }

        function selectAll() {
            const selectElement = document.getElementById('users');
            const options = selectElement.options;

            for (let i = 0; i < options.length; i++) {
                options[i].selected = true;
            }
        }

        function clearSelection() {
            const selectElement = document.getElementById('users');
            const options = selectElement.options;

            for (let i = 0; i < options.length; i++) {
                options[i].selected = false;
            }
        }
    </script>
@endsection
