<!-- resources/views/layouts/app.blade.php -->
<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" href="{{ asset('favicon.png') }}" type="image/png">
    <title>{{ config('app.name', 'Gestion Tareas') }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            background-color: #343a40;
        }
        
        @media (min-width: 768px) {
            .sidebar {
                min-height: 100vh;
            }
        }

        .notification-badge {
            position: absolute;
            top: -5px;
            right: -10px;
            background-color: #dc3545;
            color: white;
            border-radius: 50%;
            padding: 2px 6px;
            font-size: 0.75rem;
        }

        .project-card {
            transition: transform 0.2s;
        }

        .project-card:hover {
            transform: translateY(-2px);
        }

        .priority-badge {
            font-size: 0.8rem;
        }
    </style>
</head>

<body>
    <div id="app">
        @auth
            <!-- Mobile Navbar -->
            <nav class="navbar navbar-dark bg-dark d-md-none p-2 mb-3">
                <span class="navbar-brand mb-0 h1">{{ config('app.name', 'Gestion Tareas') }}</span>
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#sidebarMenu"
                    aria-controls="sidebarMenu" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
            </nav>

            <div class="container-fluid">
                <div class="row">
                    <!-- Sidebar -->
                    <nav id="sidebarMenu" class="col-md-3 col-lg-2 d-md-block bg-dark sidebar collapse">
                        <div class="sidebar-sticky pt-3">
                            <div class="text-center text-white mb-4">
                                <h5>{{ auth()->user()->nombre_corto }}</h5>
                                <small class="text-muted">{{ auth()->user()->getRoleNames()->first() }}</small>
                            </div>

                            <ul class="nav flex-column">
                                @if (auth()->user()->hasRole('administrador'))
                                    <li class="nav-item">
                                        <a class="nav-link text-white" href="{{ route('admin.dashboard') }}">
                                            <i class="fas fa-tachometer-alt"></i> Dashboard
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link text-white" href="{{ route('admin.users.index') }}">
                                            <i class="fas fa-users"></i> Usuarios
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link text-white" href="{{ route('admin.anydesk.index') }}">
                                            <i class="fas fa-desktop"></i> Terminales Anydesk
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link text-white" href="{{ route('admin.api-keys.index') }}">
                                            <i class="fas fa-key"></i> API Keys
                                        </a>
                                    </li>
                                    
                                @elseif(auth()->user()->hasRole('proveedor'))
                                    <li class="nav-item">
                                        <a class="nav-link text-white" href="{{ route('proveedor.dashboard') }}">
                                            <i class="fas fa-tachometer-alt"></i> Dashboard
                                        </a>
                                    </li>
                                    
                                @elseif(auth()->user()->hasRole('operador'))
                                    <li class="nav-item">
                                        <a class="nav-link text-white" href="{{ route('operador.dashboard') }}">
                                            <i class="fas fa-tachometer-alt"></i> Dashboard
                                        </a>
                                    </li>
                                @endif

                                <li class="nav-item">
                                    <a class="nav-link text-white" href="{{ route('empresas.index') }}">
                                        <i class="fas fa-building"></i> Empresas
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link text-white" href="{{ route('tareas.index') }}">
                                        <i class="fas fa-tasks"></i> Tareas
                                    </a>
                                </li>
                                @if(auth()->user()->hasAnyRole(['administrador','proveedor']))
                                <li class="nav-item">
                                    <a class="nav-link text-white" href="{{ route('reportes.index') }}">
                                        <i class="fas fa-file-invoice"></i> Reportes
                                    </a>
                                </li>
                                @endif
                                <li class="nav-item">
                                    <a class="nav-link text-white" href="{{ route('empresas.credenciales') }}">
                                        <i class="fas fa-key"></i> Credenciales
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link text-white" href="{{ route('notificaciones.index') }}">
                                        <i class="fas fa-bell"></i> Notificación
                                        <span id="notification-count" class="notification-badge d-none"></span>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link text-white" href="{{ route('profile.edit') }}">
                                        <i class="fas fa-user-cog"></i> Perfil
                                    </a>
                                </li>
                            </ul>

                            <div class="mt-auto mb-3">
                                <a class="nav-link text-white" href="{{ route('logout') }}"
                                    onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                    <i class="fas fa-sign-out-alt"></i> Cerrar Sesión
                                </a>
                                <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                    @csrf
                                </form>
                            </div>
                        </div>
                    </nav>

                    <!-- Main content -->
                    <main class="col-md-9 ml-sm-auto col-lg-10 px-4">
                        @if (session('success'))
                            <div class="alert alert-success alert-dismissible fade show mt-3" role="alert">
                                {{ session('success') }}
                                <button type="button" class="close" data-dismiss="alert">
                                    <span>&times;</span>
                                </button>
                            </div>
                        @endif

                        @if (session('error'))
                            <div class="alert alert-danger alert-dismissible fade show mt-3" role="alert">
                                {{ session('error') }}
                                <button type="button" class="close" data-dismiss="alert">
                                    <span>&times;</span>
                                </button>
                            </div>
                        @endif

                        @yield('content')
                    </main>
                </div>
            </div>
        @else
            <main class="py-4">
                @yield('content')
            </main>
        @endauth
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.bundle.min.js"></script>

    @auth
        <script>
            // Actualizar contador de notificaciones
            function updateNotificationCount() {
                $.get('{{ route("notificaciones.count") }}', function(data) {
                    const badge = $('#notification-count');
                    if (data.count > 0) {
                        badge.text(data.count).removeClass('d-none');
                    } else {
                        badge.addClass('d-none');
                    }
                });
            }

            // Actualizar cada 30 segundos
            setInterval(updateNotificationCount, 30000);
            updateNotificationCount();
        </script>
    @endauth

    @yield('scripts')
</body>

</html>
