@extends('layouts.app')

@section('content')
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">{{ $empresa->razon_social }}</h1>

        <div class="btn-group">
            <a href="{{ route('empresas.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Volver
            </a>

            @can('update', $empresa)
                <a href="{{ route('empresas.edit', $empresa) }}" class="btn btn-primary">
                    <i class="fas fa-edit"></i> Editar
                </a>
            @endcan

            @can('addProjects', $empresa)
                <a href="{{ route('empresas.add-tareas', $empresa) }}" class="btn btn-success">
                    <i class="fas fa-plus"></i> Agregar Tareas
                </a>
            @endcan

            @can('approve', $empresa)
                <form method="POST" action="{{ route('empresas.approve', $empresa) }}" class="d-inline">
                    @csrf
                    @method('PATCH')
                    <button type="submit" class="btn btn-success" onclick="return confirm('¿Aprobar esta empresa?')">
                        <i class="fas fa-check"></i> Aprobar
                    </button>
                </form>
            @endcan

            @can('reject', $empresa)
                <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#rejectModal">
                    <i class="fas fa-times"></i> Rechazar
                </button>
            @endcan


            @can('delete', $empresa)
                <button type="button" class="btn btn-outline-danger" data-toggle="modal" data-target="#deleteEmpresaModal">
                    <i class="fas fa-trash"></i> Eliminar
                </button>
            @endcan
        </div>
    </div>

    <!-- Información de la Empresa -->
    <div class="row mb-4">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h5>Información de la Empresa</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <strong>Razón Social:</strong> {{ $empresa->razon_social }}<br>
                            <strong>RUC:</strong> {{ $empresa->ruc }}<br>
                            <strong>Responsables:</strong>
                            @if($empresa->proveedores->count() > 0)
                                <ul class="list-unstyled mb-0 pl-3">
                                    @foreach($empresa->proveedores as $proveedor)
                                        <li>- {{ $proveedor->nombre_corto }}</li>
                                    @endforeach
                                </ul>
                            @else
                                Sin asignar<br>
                            @endif
                            <strong>Estado:</strong>
                            @if ($empresa->estado == 'aprobada')
                                @php
                                    $tareasPendientes = $empresa->tareas->where('estado', '!=', 'finalizado')->count();
                                @endphp
                                @if ($tareasPendientes > 0)
                                    <span class="badge badge-danger">{{ $tareasPendientes }} Pendientes</span>
                                @else
                                    <span class="badge badge-success">{{ ucfirst($empresa->estado) }}</span>
                                @endif
                            @else
                                <span
                                    class="badge badge-{{ $empresa->estado === 'pendiente' ? 'warning' : 'danger' }}">
                                    {{ ucfirst($empresa->estado) }}
                                </span>
                            @endif<br>
                            <strong>Fecha de Solicitud:</strong> {{ $empresa->fecha_solicitud->format('d/m/Y') }}
                        </div>
                        <div class="col-md-6">
                            <strong>Nombre Comercial:</strong> {{ $empresa->nombre_comercial ?? 'N/A' }}<br>
                            <strong>Serie:</strong> {{ $empresa->serie ?? 'N/A' }}<br>
                            @unless(auth()->user()->hasRole('operador'))
                            <strong>Usuario SOL:</strong> {{ $empresa->usuario_sol ?? 'N/A' }}<br>
                            <strong>Clave SOL:</strong> {{ $empresa->clave_sol ?? 'N/A' }}<br>
                            <hr class="my-2">
                            <strong>Usuario Secundario DNI:</strong> {{ $empresa->usuario_secundario_dni ?? 'N/A' }}<br>
                            <strong>Usuario Secundario:</strong> {{ $empresa->usuario_secundario_user ?? 'N/A' }}<br>
                            <strong>Clave Secundario:</strong> {{ $empresa->usuario_secundario_clave ?? 'N/A' }}<br>
                            <strong>Clave Certificado:</strong> {{ $empresa->clave_certificado ?? 'N/A' }}<br>
                            @endunless
                            @if ($empresa->aprobado_por)
                                <hr class="my-2">
                                <strong>Aprobado por:</strong> {{ $empresa->aprobadoPor->nombre_completo }}<br>
                                <strong>Fecha de aprobación:</strong> {{ $empresa->fecha_aprobacion->format('d/m/Y H:i') }}
                            @endif
                        </div>
                    </div>

                    @if ($empresa->descripcion)
                        <div class="mt-3">
                            <strong>Descripción:</strong><br>
                            {{ $empresa->descripcion }}
                        </div>
                    @endif

                    @if ($empresa->comentarios_aprobacion)
                        <div class="mt-3">
                            <div class="alert alert-warning">
                                <strong>Comentarios de
                                    {{ $empresa->estado === 'rechazada' ? 'rechazo' : 'aprobación' }}:</strong><br>
                                {{ $empresa->comentarios_aprobacion }}
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <!-- Estadísticas de Tareas -->
            <div class="card">
                <div class="card-header">
                    <h5>Estado de Tareas</h5>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-4">
                            <h4 class="text-warning">{{ $empresa->tareas->where('estado', 'pendiente')->count() }}</h4>
                            <small class="text-muted">Pendientes</small>
                        </div>
                        <div class="col-4">
                            <h4 class="text-primary">{{ $empresa->tareas->where('estado', 'en_progreso')->count() }}</h4>
                            <small class="text-muted">En Progreso</small>
                        </div>
                        <div class="col-4">
                            <h4 class="text-success">{{ $empresa->tareas->where('estado', 'finalizado')->count() }}</h4>
                            <small class="text-muted">Finalizadas</small>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Estadísticas por Prioridad -->
            <div class="card mt-3">
                <div class="card-header">
                    <h5>Tareas por Prioridad</h5>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-6">
                            <h5 class="text-danger">{{ $empresa->tareas->where('prioridad', 'urgente')->count() }}</h5>
                            <small class="text-muted">Urgente</small>
                        </div>
                        <div class="col-6">
                            <h5 class="text-warning">{{ $empresa->tareas->where('prioridad', 'alta')->count() }}</h5>
                            <small class="text-muted">Alta</small>
                        </div>
                        <div class="col-6">
                            <h5 class="text-info">{{ $empresa->tareas->where('prioridad', 'media')->count() }}</h5>
                            <small class="text-muted">Media</small>
                        </div>
                        <div class="col-6">
                            <h5 class="text-secondary">{{ $empresa->tareas->where('prioridad', 'baja')->count() }}</h5>
                            <small class="text-muted">Baja</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Lista de Tareas -->
    <div class="card">
        <div class="card-header">
            <h5>Tareas de la Empresa ({{ $empresa->tareas->count() }})</h5>
        </div>
        <div class="card-body">
            @if ($empresa->tareas->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Tarea</th>
                                <th>Operador</th>
                                <th>Prioridad</th>
                                <th>Estado</th>
                                <th>Fecha Límite</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($empresa->tareas as $tarea)
                                <tr
                                    class="{{ $tarea->fecha_fin_estimada->isPast() && $tarea->estado != 'finalizado' ? 'table-warning' : '' }}">
                                    <td>{{ $tarea->orden }}</td>
                                    <td>
                                        <strong>{{ $tarea->titulo }}</strong><br>
                                        <small class="text-muted">{{ Str::limit($tarea->descripcion, 50) }}</small>
                                    </td>
                                    <td>{{ $tarea->operador->nombre_completo }}</td>
                                    <td>
                                        <span class="badge badge-{{ $tarea->prioridad_color }}">
                                            {{ ucfirst($tarea->prioridad) }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge badge-{{ $tarea->estado_color }}">
                                            {{ ucfirst(str_replace('_', ' ', $tarea->estado)) }}
                                        </span>
                                    </td>
                                    <td>
                                        {{ $tarea->fecha_fin_estimada->format('d/m/Y') }}
                                        @if ($tarea->fecha_fin_estimada->isPast() && $tarea->estado != 'finalizado')
                                            <br><small class="text-danger">
                                                <i class="fas fa-exclamation-triangle"></i>
                                                Retrasado {{ abs($tarea->dias_restantes) }} días
                                            </small>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            @can('view', $tarea)
                                                <a href="{{ route('tareas.show', $tarea) }}"
                                                    class="btn btn-sm btn-outline-primary" title="Ver detalles">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            @endcan

                                            @can('update', $tarea)
                                                <a href="{{ route('tareas.edit', $tarea) }}"
                                                    class="btn btn-sm btn-outline-warning" title="Editar tarea">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            @endcan

                                            @can('updateStatus', $tarea)
                                                @if($tarea->estado === 'finalizado')
                                                    <button type="button" class="btn btn-sm btn-outline-success" 
                                                        onclick="verSolucion('{{ addslashes($tarea->observaciones_finales) }}')"
                                                        title="Ver Solución">
                                                        <i class="fas fa-check-double"></i>
                                                    </button>
                                                @else
                                                    <div class="btn-group" role="group">
                                                        <button type="button"
                                                            class="btn btn-sm btn-outline-info dropdown-toggle"
                                                            data-toggle="dropdown" title="Cambiar estado">
                                                            <i class="fas fa-exchange-alt"></i>
                                                        </button>
                                                        <ul class="dropdown-menu">
                                                            @if ($tarea->estado != 'pendiente')
                                                                <li>
                                                                    <a class="dropdown-item" href="#"
                                                                        onclick="cambiarEstado({{ $tarea->id }}, 'pendiente')">
                                                                        <i class="fas fa-clock text-warning me-2"></i>
                                                                        Pendiente
                                                                    </a>
                                                                </li>
                                                            @endif
                                                            @if ($tarea->estado != 'en_progreso')
                                                                <li>
                                                                    <a class="dropdown-item" href="#"
                                                                        onclick="cambiarEstado({{ $tarea->id }}, 'en_progreso')">
                                                                        <i class="fas fa-spinner text-primary me-2"></i>
                                                                        En Progreso
                                                                    </a>
                                                                </li>
                                                            @endif
                                                            @if ($tarea->estado != 'finalizado')
                                                                <li>
                                                                    <a class="dropdown-item" href="#"
                                                                        onclick="cambiarEstado({{ $tarea->id }}, 'finalizado')">
                                                                        <i class="fas fa-check-circle text-success me-2"></i>
                                                                        Finalizado
                                                                    </a>
                                                                </li>
                                                            @endif
                                                            @if ($tarea->estado != 'cancelado')
                                                                <li>
                                                                    <a class="dropdown-item" href="#"
                                                                        onclick="cambiarEstado({{ $tarea->id }}, 'cancelado')">
                                                                        <i class="fas fa-ban text-danger me-2"></i>
                                                                        Cancelado
                                                                    </a>
                                                                </li>
                                                            @endif
                                                        </ul>
                                                    </div>
                                                @endif
                                            @endcan

                                            @can('delete', $tarea)
                                                <form action="{{ route('tareas.destroy', $tarea) }}" method="POST" class="d-inline" onsubmit="return confirm('¿Estás seguro de eliminar esta tarea?');">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-outline-danger" title="Eliminar tarea">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="alert alert-info">
                    <i class="fas fa-info-circle"></i> Esta empresa no tiene tareas asignadas.
                </div>
            @endif
        </div>
    </div>

    <!-- Modales -->
    @can('reject', $empresa)
        <div class="modal fade" id="rejectModal" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form method="POST" action="{{ route('empresas.reject', $empresa) }}">
                        @csrf
                        @method('PATCH')
                        <div class="modal-header">
                            <h5 class="modal-title">Rechazar Empresa</h5>
                            <button type="button" class="close" data-dismiss="modal">
                                <span>&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label for="comentarios_aprobacion">Motivo del rechazo</label>
                                <textarea class="form-control" name="comentarios_aprobacion" rows="4"
                                    placeholder="Explica por qué se rechaza esta empresa..." required></textarea>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                            <button type="submit" class="btn btn-danger">Rechazar Empresa</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endcan

    <!-- Modales genéricos para tareas -->
    <div class="modal fade" id="cambiarEstadoModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="cambiarEstadoForm" method="POST">
                    @csrf
                    @method('PATCH')
                    <div class="modal-header">
                        <h5 class="modal-title">Cambiar Estado de la Tarea</h5>
                        <button type="button" class="close" data-dismiss="modal">
                            <span>&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>¿Estás seguro de que deseas cambiar el estado de esta tarea?</p>
                        <input type="hidden" name="estado" id="nuevoEstado">
                        
                        <div class="form-group" id="observacionesContainer" style="display: none;">
                            <label for="observaciones_finales" class="font-weight-bold">Observaciones Finales (Solución):</label>
                            <textarea class="form-control text-uppercase" name="observaciones_finales" id="observacionesFinales" rows="3" 
                                placeholder="Describa los procesos o cambios realizados..."
                                oninput="this.value = this.value.toUpperCase()"></textarea>
                            <small class="text-muted">Esta información no podrá ser modificada una vez guardada.</small>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Confirmar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="verSolucionModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title">
                        <i class="fas fa-check-double mr-2"></i> Solución de la Tarea
                    </h5>
                    <button type="button" class="close text-white" data-dismiss="modal">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-light border">
                        <p id="textoSolucion" class="mb-0" style="white-space: pre-wrap;"></p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Eliminar Empresa -->
    <div class="modal fade" id="deleteEmpresaModal" tabindex="-1" role="dialog" aria-labelledby="deleteEmpresaModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title" id="deleteEmpresaModalLabel">Confirmar Eliminación</h5>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="text-center mb-3">
                        <i class="fas fa-exclamation-triangle text-warning fa-3x"></i>
                    </div>
                    <p class="text-center font-weight-bold">¿Estás seguro de que deseas eliminar esta empresa?</p>
                    <p class="text-center text-muted">Esta acción eliminará la empresa <strong id="deleteEmpresaName">{{ $empresa->razon_social }}</strong> y todas sus tareas asociadas permanentemente. Esta acción no se puede deshacer.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                    <form id="deleteEmpresaForm" method="POST" action="{{ route('empresas.destroy', $empresa) }}">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger">Sí, eliminar empresa</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        // Tooltip para elementos con información adicional
        $(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });

        // Confirmación para acciones críticas
        function confirmarAccion(mensaje) {
            return confirm(mensaje);
        }

        function verSolucion(solucion) {
            document.getElementById('textoSolucion').innerText = solucion || 'Sin observaciones registradas.';
            $('#verSolucionModal').modal('show');
        }

        function cambiarEstado(tareaId, nuevoEstado) {
            const form = document.getElementById('cambiarEstadoForm');
            var url = '{{ route("tareas.update-status", ":id") }}';
            form.action = url.replace(':id', tareaId);
            document.getElementById('nuevoEstado').value = nuevoEstado;
            
            const obsContainer = document.getElementById('observacionesContainer');
            const obsInput = document.getElementById('observacionesFinales');
            
            if (nuevoEstado === 'finalizado') {
                obsContainer.style.display = 'block';
                obsInput.required = true;
            } else {
                obsContainer.style.display = 'none';
                obsInput.required = false;
                obsInput.value = '';
            }
            
            $('#cambiarEstadoModal').modal('show');
        }
    </script>
@endsection
