<div class="modal-header">
    <h5 class="modal-title" id="showEmpresaModalLabel">Tareas de "{{ $empresa->nombre_comercial ?? $empresa->razon_social }}"</h5>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
</div>

<div class="modal-body">
    <!-- Estadísticas Compactas -->
    <div class="card mb-3 shadow-sm border-0 bg-white">
        <div class="card-body py-3">
            <div class="row align-items-center">
                <!-- Estado -->
                <div class="col-md-5 border-right">
                    <h6 class="text-muted text-uppercase small font-weight-bold mb-2">Estado de Tareas</h6>
                    <div class="d-flex justify-content-around text-center">
                        <div>
                            <span class="h5 font-weight-bold text-warning d-block mb-0">{{ $empresa->tareas->where('estado', 'pendiente')->count() }}</span>
                            <small class="text-muted" style="font-size: 0.75rem;">Pendientes</small>
                        </div>
                        <div>
                            <span class="h5 font-weight-bold text-primary d-block mb-0">{{ $empresa->tareas->where('estado', 'en_progreso')->count() }}</span>
                            <small class="text-muted" style="font-size: 0.75rem;">En Progreso</small>
                        </div>
                        <div>
                            <span class="h5 font-weight-bold text-success d-block mb-0">{{ $empresa->tareas->where('estado', 'finalizado')->count() }}</span>
                            <small class="text-muted" style="font-size: 0.75rem;">Finalizadas</small>
                        </div>
                    </div>
                </div>

                <!-- Prioridad -->
                <div class="col-md-7">
                    <h6 class="text-muted text-uppercase small font-weight-bold mb-2">Por Prioridad</h6>
                    <div class="d-flex justify-content-around text-center">
                        <div>
                            <span class="h5 font-weight-bold text-danger d-block mb-0">{{ $empresa->tareas->where('prioridad', 'urgente')->count() }}</span>
                            <small class="text-muted" style="font-size: 0.75rem;">Urgente</small>
                        </div>
                        <div>
                            <span class="h5 font-weight-bold text-warning d-block mb-0">{{ $empresa->tareas->where('prioridad', 'alta')->count() }}</span>
                            <small class="text-muted" style="font-size: 0.75rem;">Alta</small>
                        </div>
                        <div>
                            <span class="h5 font-weight-bold text-info d-block mb-0">{{ $empresa->tareas->where('prioridad', 'media')->count() }}</span>
                            <small class="text-muted" style="font-size: 0.75rem;">Media</small>
                        </div>
                        <div>
                            <span class="h5 font-weight-bold text-secondary d-block mb-0">{{ $empresa->tareas->where('prioridad', 'baja')->count() }}</span>
                            <small class="text-muted" style="font-size: 0.75rem;">Baja</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Lista de Tareas -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Lista de Tareas ({{ $tareas->total() }})</h5>
            <div class="d-flex align-items-center">
                <select id="filterEstado" class="form-control form-control-sm mr-2" style="width: 150px;" onchange="updateTaskFilter(this.value)">
                    <option value="todos" {{ request('estado') == 'todos' ? 'selected' : '' }}>Todos</option>
                    <option value="no_finalizado" {{ request('estado') == 'no_finalizado' ? 'selected' : '' }}>No Finalizados</option>
                    <option value="pendiente" {{ request('estado') == 'pendiente' ? 'selected' : '' }}>Pendientes</option>
                    <option value="en_progreso" {{ request('estado') == 'en_progreso' ? 'selected' : '' }}>En Progreso</option>
                    <option value="finalizado" {{ request('estado') == 'finalizado' ? 'selected' : '' }}>Finalizados</option>
                    <option value="cancelado" {{ request('estado') == 'cancelado' ? 'selected' : '' }}>Cancelados</option>
                </select>

                @can('addProjects', $empresa)
                    <button type="button" class="btn btn-sm btn-success" onclick="showAddTareasModal({{ $empresa->id }})">
                        <i class="fas fa-plus"></i> Nueva Tarea
                    </button>
                @endcan
            </div>
        </div>
        <div class="card-body">
            @if ($empresa->tareas->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>
                                    <a href="#" class="sort-link text-dark" data-sort="orden"># <i class="fas fa-sort"></i></a>
                                </th>
                                <th>
                                    <a href="#" class="sort-link text-dark" data-sort="titulo">Tarea <i class="fas fa-sort"></i></a>
                                </th>
                                <th>
                                    <a href="#" class="sort-link text-dark" data-sort="operador_id">Operador <i class="fas fa-sort"></i></a>
                                </th>
                                <th>
                                    <a href="#" class="sort-link text-dark" data-sort="prioridad">Prioridad <i class="fas fa-sort"></i></a>
                                </th>
                                <th>
                                    <a href="#" class="sort-link text-dark" data-sort="estado">Estado <i class="fas fa-sort"></i></a>
                                </th>
                                <th>
                                    <a href="#" class="sort-link text-dark" data-sort="fecha_fin_estimada">Fecha Límite <i class="fas fa-sort"></i></a>
                                </th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($tareas as $tarea)
                                <tr
                                    class="{{ $tarea->fecha_fin_estimada->isPast() && $tarea->estado != 'finalizado' ? 'table-warning' : '' }}">
                                    <td>{{ $tarea->orden }}</td>
                                    <td>
                                        <strong>{{ $tarea->titulo }}</strong><br>
                                        <small class="text-muted">{{ Str::limit($tarea->descripcion, 50) }}</small>
                                    </td>
                                    <td>{{ $tarea->operador->nombre_completo }}</td>
                                    <td>
                                        <span class="badge badge-{{ $tarea->prioridad_color }}">
                                            {{ ucfirst($tarea->prioridad) }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge badge-{{ $tarea->estado_color }}">
                                            {{ ucfirst(str_replace('_', ' ', $tarea->estado)) }}
                                        </span>
                                    </td>
                                    <td>
                                        {{ $tarea->fecha_fin_estimada->format('d/m/Y') }}
                                        @if ($tarea->fecha_fin_estimada->isPast() && $tarea->estado != 'finalizado')
                                            <br><span class="badge badge-danger">Vencida</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm" role="group">
                                            @can('view', $tarea)
                                                <button type="button" class="btn btn-info text-white"
                                                    title="Ver detalles" onclick="showTareaDetails({{ $tarea->id }})">
                                                    <i class="fas fa-eye"></i>
                                                </button>
                                            @endcan
                                            @can('update', $tarea)
                                                <button type="button" class="btn btn-warning"
                                                    title="Editar tarea" onclick="showEditTareaModal({{ $tarea->id }})">
                                                    <i class="fas fa-edit"></i>
                                                </button>
                                            @endcan
                                            @can('delete', $tarea)
                                                <form action="{{ route('tareas.destroy', $tarea) }}" method="POST"
                                                    class="d-inline delete-task-form">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger" title="Eliminar tarea">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    
                    <div class="d-flex justify-content-center mt-3" id="tareas-pagination">
                        {{ $tareas->links() }}
                    </div>
                </div>
            @else
                <p class="text-center">No hay tareas registradas para esta empresa.</p>
            @endif
        </div>
    </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
    <a href="{{ route('empresas.show', $empresa) }}" class="btn btn-primary">Ver Página Completa</a>
</div>
