<div class="modal-header">
    <h5 class="modal-title" id="showEmpresaModalLabel">Detalles de la Empresa</h5>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
</div>

<div class="modal-body" id="showEmpresaModalBody">
    <!-- Header Compacto Unificado -->
    <div class="card shadow-sm mb-4">
        <div class="card-body py-3">
            <div class="row">
                <!-- Información Empresa -->
                <div class="col-md-7 border-right">
                    <h6 class="text-primary font-weight-bold mb-3"><i class="fas fa-building me-1"></i> Información de la Empresa</h6>
                    <div class="row">
                        <div class="col-md-6">
                            <small class="text-muted d-block uppercase">Razón Social</small>
                            <span class="font-weight-bold text-dark">{{ $empresa->razon_social }}</span>
                        </div>
                        <div class="col-md-6">
                            <small class="text-muted d-block uppercase">Nombre Comercial</small>
                            <span class="font-weight-bold text-dark">{{ $empresa->nombre_comercial ?? 'N/A' }}</span>
                        </div>
                        <div class="col-md-6 mt-2">
                            <small class="text-muted d-block uppercase">RUC</small>
                            <span>{{ $empresa->ruc }}</span>
                        </div>
                        <div class="col-md-6 mt-2">
                            <small class="text-muted d-block uppercase">Modo de Pago</small>
                            <span class="badge badge-info">{{ ucfirst($empresa->modo_pago) }}</span>
                        </div>
                        <div class="col-md-6 mt-2">
                            <small class="text-muted d-block uppercase">Responsables</small>
                            @if($empresa->proveedores->count() > 0)
                                @foreach($empresa->proveedores as $proveedor)
                                    <span class="badge badge-light border">{{ $proveedor->nombre_corto }}</span>
                                @endforeach
                            @else
                                <span class="text-muted small">Sin asignar</span>
                            @endif
                        </div>
                        @unless(auth()->user()->hasRole('operador'))
                        <div class="col-md-6 mt-2 border-top pt-2">
                             <small class="text-muted d-block">Usuario SOL: <span class="text-dark font-weight-bold">{{ $empresa->usuario_sol ?? 'N/A' }}</span></small>
                        </div>
                         <div class="col-md-6 mt-2 border-top pt-2">
                             <small class="text-muted d-block">Clave SOL: <span class="text-dark font-weight-bold">{{ $empresa->clave_sol ?? 'N/A' }}</span></small>
                        </div>
                        @endunless
                    </div>
                </div>
                
                <!-- Estadísticas Unificadas -->
                <div class="col-md-5">
                    <h6 class="text-success font-weight-bold mb-3"><i class="fas fa-chart-pie me-1"></i> Métricas</h6>
                    
                    <!-- Estado -->
                    <div class="mb-3">
                        <small class="text-uppercase text-muted font-weight-bold" style="font-size: 0.7rem;">Estado de Tareas</small>
                        <div class="d-flex justify-content-between mt-1 text-center bg-light p-2 rounded">
                            <div><span class="h5 font-weight-bold text-warning mb-0 d-block">{{ $empresa->tareas->where('estado', 'pendiente')->count() }}</span><small>Pend.</small></div>
                            <div><span class="h5 font-weight-bold text-primary mb-0 d-block">{{ $empresa->tareas->where('estado', 'en_progreso')->count() }}</span><small>Prog.</small></div>
                            <div><span class="h5 font-weight-bold text-success mb-0 d-block">{{ $empresa->tareas->where('estado', 'finalizado')->count() }}</span><small>Fin.</small></div>
                        </div>
                    </div>

                    <!-- Prioridad -->
                    <div>
                        <small class="text-uppercase text-muted font-weight-bold" style="font-size: 0.7rem;">Por Prioridad</small>
                        <div class="d-flex justify-content-between mt-1 text-center">
                            <span class="badge badge-danger p-2">{{ $empresa->tareas->where('prioridad', 'urgente')->count() }} Urg.</span>
                            <span class="badge badge-warning p-2">{{ $empresa->tareas->where('prioridad', 'alta')->count() }} Alt.</span>
                            <span class="badge badge-info p-2">{{ $empresa->tareas->where('prioridad', 'media')->count() }} Med.</span>
                            <span class="badge badge-secondary p-2">{{ $empresa->tareas->where('prioridad', 'baja')->count() }} Baj.</span>
                        </div>
                    </div>
                </div>
            </div>
            
             @if ($empresa->comentarios_aprobacion)
                <div class="mt-3 border-top pt-2">
                    <div class="alert alert-warning mb-0 p-2 small">
                        <strong>{{ $empresa->estado === 'rechazada' ? 'Rechazo' : 'Aprobación' }}:</strong> {{ $empresa->comentarios_aprobacion }}
                    </div>
                </div>
            @endif
        </div>
    </div>

    <!-- Lista de Tareas -->
    <div class="card">
        <div class="card-header">
            <h5>Tareas de la Empresa ({{ $empresa->tareas->count() }})</h5>
        </div>
        <div class="card-body">
            @if ($empresa->tareas->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Tarea</th>
                                <th>Operador</th>
                                <th>Prioridad</th>
                                <th>Estado</th>
                                <th>Fecha Límite</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($empresa->tareas as $tarea)
                                <tr
                                    class="{{ $tarea->fecha_fin_estimada->isPast() && $tarea->estado != 'finalizado' ? 'table-warning' : '' }}">
                                    <td>{{ $tarea->orden }}</td>
                                    <td>
                                        <strong>{{ $tarea->titulo }}</strong><br>
                                        <small class="text-muted">{{ Str::limit($tarea->descripcion, 50) }}</small>
                                    </td>
                                    <td>{{ $tarea->operador->nombre_completo }}</td>
                                    <td>
                                        <span class="badge badge-{{ $tarea->prioridad_color }}">
                                            {{ ucfirst($tarea->prioridad) }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge badge-{{ $tarea->estado_color }}">
                                            {{ ucfirst(str_replace('_', ' ', $tarea->estado)) }}
                                        </span>
                                    </td>
                                    <td>
                                        {{ $tarea->fecha_fin_estimada->format('d/m/Y') }}
                                        @if ($tarea->fecha_fin_estimada->isPast() && $tarea->estado != 'finalizado')
                                            <br><span class="badge badge-danger">Vencida</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <p class="text-center">No hay tareas registradas para esta empresa.</p>
            @endif
        </div>
    </div>
    
    @can('reject', $empresa)
    <div id="rejectionForm" style="display: none;" class="mt-4">
        <div class="card border-danger">
            <div class="card-header bg-danger text-white">
                Rechazar Empresa
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('empresas.reject', $empresa) }}">
                    @csrf
                    @method('PATCH')
                    <div class="form-group">
                        <label for="comentarios_aprobacion">Motivo del rechazo</label>
                        <textarea class="form-control" name="comentarios_aprobacion" rows="3"
                            placeholder="Explica por qué se rechaza esta empresa..." required></textarea>
                    </div>
                    <div class="text-right">
                        <button type="button" class="btn btn-secondary" onclick="$('#rejectionForm').hide()">Cancelar</button>
                        <button type="submit" class="btn btn-danger">Confirmar Rechazo</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    @endcan
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
    <a href="{{ route('empresas.show', $empresa) }}" class="btn btn-primary">Ver Página Completa</a>
    
    @can('approve', $empresa)
        <form method="POST" action="{{ route('empresas.approve', $empresa) }}" class="d-inline">
            @csrf
            @method('PATCH')
            <button type="submit" class="btn btn-success" onclick="return confirm('¿Aprobar esta empresa?')">
                <i class="fas fa-check"></i> Aprobar
            </button>
        </form>
    @endcan

    @can('reject', $empresa)
        <button type="button" class="btn btn-danger" onclick="$('#rejectionForm').slideDown();">
            <i class="fas fa-times"></i> Rechazar
        </button>
    @endcan
</div>
