<div class="modal-header">
    <h5 class="modal-title">RUCs Asignados: {{ $empresa->razon_social }}</h5>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
</div>
<div class="modal-body">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h6>Lista de RUCs</h6>
        <button type="button" class="btn btn-sm btn-primary" onclick="loadAddRucForm({{ $empresa->id }})">
            <i class="fas fa-plus"></i> Agregar Nuevo RUC
        </button>
    </div>

    <div class="table-responsive">
        <table class="table table-bordered table-sm">
            <thead class="thead-light">
                <tr>
                    <th>RUC</th>
                    <th>Razón Social</th>
                    <th>Serie</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <!-- Main RUC -->
                <tr class="table-active">
                    <td>{{ $empresa->ruc }}</td>
                    <td>{{ $empresa->razon_social }}</td>
                    <td>{{ $empresa->serie ?? '-' }}</td>
                    <td><span class="badge badge-info">Principal</span></td>
                </tr>
                <!-- Other RUCs -->
                @forelse($empresa->otrosRucs as $otroRuc)
                    <tr>
                        <td>{{ $otroRuc->ruc }}</td>
                        <td>{{ $otroRuc->razon_social }}</td>
                        <td>{{ $otroRuc->serie ?? '-' }}</td>
                        <td>
                            <button type="button" class="btn btn-sm btn-info" onclick="loadEditRucForm({{ $otroRuc->id }})" title="Editar"><i class="fas fa-edit"></i></button>
                            <button type="button" class="btn btn-sm btn-danger" onclick="deleteRuc('{{ route('empresas.rucs.destroy', $otroRuc->id) }}', {{ $empresa->id }})" title="Eliminar"><i class="fas fa-trash"></i></button>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="4" class="text-center text-muted">No hay RUCs adicionales registrados.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
</div>
