<div class="modal-header">
    <h5 class="modal-title">Agregar RUC a: {{ $empresa->razon_social }}</h5>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
</div>
<form method="POST" action="{{ route('empresas.rucs.store', $empresa->id) }}">
    @csrf
    <div class="modal-body">
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="extra_ruc">RUC</label>
                    <input type="text" class="form-control" id="extra_ruc" name="ruc" maxlength="11" required>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="extra_razon_social">Razón Social</label>
                    <input type="text" class="form-control text-uppercase" id="extra_razon_social" name="razon_social" required oninput="this.value = this.value.toUpperCase()">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label for="extra_serie">Serie (3 dígitos)</label>
                    <input type="text" class="form-control" id="extra_serie" name="serie" maxlength="3" placeholder="001">
                </div>
            </div>
        </div>
        @unless(auth()->user()->hasRole('operador'))
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="extra_usuario_sol">Usuario SOL</label>
                    <input type="text" class="form-control" id="extra_usuario_sol" name="usuario_sol">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="extra_clave_sol">Clave SOL</label>
                    <input type="text" class="form-control" id="extra_clave_sol" name="clave_sol">
                </div>
            </div>
        </div>
        <h6 class="mt-3">Usuario Secundario</h6>
        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label for="extra_usuario_secundario_dni">DNI</label>
                    <input type="text" class="form-control" id="extra_usuario_secundario_dni" name="usuario_secundario_dni" maxlength="8">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="extra_usuario_secundario_user">Usuario</label>
                    <input type="text" class="form-control" id="extra_usuario_secundario_user" name="usuario_secundario_user">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="extra_usuario_secundario_clave">Clave</label>
                    <input type="text" class="form-control" id="extra_usuario_secundario_clave" name="usuario_secundario_clave">
                </div>
            </div>
        </div>
        <div class="form-group">
            <label for="extra_clave_certificado">Clave del Certificado</label>
            <input type="text" class="form-control" id="extra_clave_certificado" name="clave_certificado">
        </div>
        @endunless
    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-secondary" onclick="showRucList({{ $empresa->id }})">Cancelar</button>
        <button type="submit" class="btn btn-primary">Agregar</button>
    </div>
</form>
