<div class="modal-header">
    <h5 class="modal-title">Editar RUC: {{ $empresaRuc->ruc }}</h5>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
</div>
<form method="POST" action="{{ route('empresas.rucs.update', $empresaRuc->id) }}" id="editRucForm" data-company-id="{{ $empresa->id }}">
    @csrf
    @method('PUT')
    <div class="modal-body">
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="edit_extra_ruc">RUC</label>
                    <input type="text" class="form-control" id="edit_extra_ruc" name="ruc" maxlength="11" required value="{{ $empresaRuc->ruc }}">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="edit_extra_razon_social">Razón Social</label>
                    <input type="text" class="form-control text-uppercase" id="edit_extra_razon_social" name="razon_social" required oninput="this.value = this.value.toUpperCase()" value="{{ $empresaRuc->razon_social }}">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label for="edit_extra_serie">Serie (3 dígitos)</label>
                    <input type="text" class="form-control" id="edit_extra_serie" name="serie" maxlength="3" placeholder="001" value="{{ $empresaRuc->serie }}">
                </div>
            </div>
        </div>
        @unless(auth()->user()->hasRole('operador'))
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="edit_extra_usuario_sol">Usuario SOL</label>
                    <input type="text" class="form-control" id="edit_extra_usuario_sol" name="usuario_sol" value="{{ $empresaRuc->usuario_sol }}">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="edit_extra_clave_sol">Clave SOL</label>
                    <input type="text" class="form-control" id="edit_extra_clave_sol" name="clave_sol" value="{{ $empresaRuc->clave_sol }}">
                </div>
            </div>
        </div>
        <h6 class="mt-3">Usuario Secundario</h6>
        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label for="edit_extra_usuario_secundario_dni">DNI</label>
                    <input type="text" class="form-control" id="edit_extra_usuario_secundario_dni" name="usuario_secundario_dni" maxlength="8" value="{{ $empresaRuc->usuario_secundario_dni }}">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="edit_extra_usuario_secundario_user">Usuario</label>
                    <input type="text" class="form-control" id="edit_extra_usuario_secundario_user" name="usuario_secundario_user" value="{{ $empresaRuc->usuario_secundario_user }}">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="edit_extra_usuario_secundario_clave">Clave</label>
                    <input type="text" class="form-control" id="edit_extra_usuario_secundario_clave" name="usuario_secundario_clave" value="{{ $empresaRuc->usuario_secundario_clave }}">
                </div>
            </div>
        </div>
        <div class="form-group">
            <label for="edit_extra_clave_certificado">Clave del Certificado</label>
            <input type="text" class="form-control" id="edit_extra_clave_certificado" name="clave_certificado" value="{{ $empresaRuc->clave_certificado }}">
        </div>
        @endunless
    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-secondary" onclick="showRucList({{ $empresa->id }})">Cancelar</button>
        <button type="submit" class="btn btn-primary">Actualizar</button>
    </div>
</form>
